/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.event;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zombie;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.zenith.hoyocraft.Hoyocraft;
import net.zenith.hoyocraft.api.capability.shield.IShield;
import net.zenith.hoyocraft.api.damage.HoyoDamageType;
import net.zenith.hoyocraft.capability.ShieldCapability;
import net.zenith.hoyocraft.damage.HoyoDamageSource;
import net.zenith.hoyocraft.entity.ai.goal.vanillamonster.BreakHilichurlCampfireGoal;
import net.zenith.hoyocraft.entity.ai.goal.vanillamonster.FindAndMoveToHilichurlCampfireGoal;

@EventBusSubscriber(modid="hoyocraft", bus=EventBusSubscriber.Bus.GAME)
public class MobInteractionEvents {
    @SubscribeEvent
    public static void onLivingDamagePre(LivingDamageEvent.Pre event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        IShield shield = (IShield)entity.getCapability(ShieldCapability.SHIELD_CAPABILITY);
        if (shield != null && shield.isActive()) {
            HoyoDamageType hoyoType;
            float originalAmount = event.getOriginalDamage();
            DamageSource source = event.getSource();
            if (source instanceof HoyoDamageSource) {
                HoyoDamageSource hoyoDamageSource = (HoyoDamageSource)source;
                hoyoType = hoyoDamageSource.getHoyoDamageType();
            } else {
                hoyoType = source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.LAVA) ? HoyoDamageType.PYRO : (source.is(DamageTypes.DROWN) ? HoyoDamageType.HYDRO : (source.is(DamageTypes.FREEZE) ? HoyoDamageType.CRYO : HoyoDamageType.GENERIC));
            }
            float leakedDamage = shield.takeDamage(originalAmount, hoyoType);
            Hoyocraft.LOGGER.info("[SHIELD DEBUG] Entity {} took {} {} damage. Shield blocked {}, {} leaked. Shield HP: {}/{}", new Object[]{entity.getId(), String.format("%.2f", Float.valueOf(originalAmount)), hoyoType.name(), String.format("%.2f", Float.valueOf(originalAmount - leakedDamage)), String.format("%.2f", Float.valueOf(leakedDamage)), String.format("%.2f", Float.valueOf(shield.getCurrentHealth())), String.format("%.2f", Float.valueOf(shield.getMaxHealth()))});
            if (leakedDamage <= 0.0f) {
                event.setNewDamage(0.0f);
                entity.level().broadcastEntityEvent((Entity)entity, (byte)2);
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GENERIC_HURT, entity.getSoundSource(), 1.0f, 1.0f);
            } else {
                event.setNewDamage(leakedDamage);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            double speedModifierToCampfire = 1.0;
            int searchRadiusForCampfire = 20;
            int timeToBreakCampfire = 100;
            if (mob instanceof Zombie) {
                Zombie zombie = (Zombie)mob;
                zombie.goalSelector.addGoal(5, (Goal)new FindAndMoveToHilichurlCampfireGoal((Mob)zombie, speedModifierToCampfire, searchRadiusForCampfire));
                zombie.goalSelector.addGoal(3, (Goal)new BreakHilichurlCampfireGoal((Mob)zombie, timeToBreakCampfire));
            } else if (mob instanceof Skeleton) {
                Skeleton skeleton = (Skeleton)mob;
                skeleton.goalSelector.addGoal(6, (Goal)new FindAndMoveToHilichurlCampfireGoal((Mob)skeleton, speedModifierToCampfire, searchRadiusForCampfire));
                skeleton.goalSelector.addGoal(4, (Goal)new BreakHilichurlCampfireGoal((Mob)skeleton, timeToBreakCampfire));
            } else if (mob instanceof Spider) {
                Spider spider = (Spider)mob;
                spider.goalSelector.addGoal(5, (Goal)new FindAndMoveToHilichurlCampfireGoal((Mob)spider, speedModifierToCampfire, searchRadiusForCampfire));
                spider.goalSelector.addGoal(3, (Goal)new BreakHilichurlCampfireGoal((Mob)spider, timeToBreakCampfire));
            } else if (mob instanceof Pillager) {
                Pillager pillager = (Pillager)mob;
                pillager.goalSelector.addGoal(5, (Goal)new FindAndMoveToHilichurlCampfireGoal((Mob)pillager, speedModifierToCampfire, searchRadiusForCampfire));
                pillager.goalSelector.addGoal(3, (Goal)new BreakHilichurlCampfireGoal((Mob)pillager, timeToBreakCampfire + 20));
            } else if (mob instanceof Vindicator) {
                Vindicator vindicator = (Vindicator)mob;
                vindicator.goalSelector.addGoal(5, (Goal)new FindAndMoveToHilichurlCampfireGoal((Mob)vindicator, speedModifierToCampfire, searchRadiusForCampfire));
                vindicator.goalSelector.addGoal(3, (Goal)new BreakHilichurlCampfireGoal((Mob)vindicator, timeToBreakCampfire - 20));
            } else if (mob instanceof Evoker) {
                Evoker evoker = (Evoker)mob;
                evoker.goalSelector.addGoal(6, (Goal)new FindAndMoveToHilichurlCampfireGoal((Mob)evoker, speedModifierToCampfire, searchRadiusForCampfire));
                evoker.goalSelector.addGoal(4, (Goal)new BreakHilichurlCampfireGoal((Mob)evoker, timeToBreakCampfire + 40));
            } else if (mob instanceof Ravager) {
                Ravager ravager = (Ravager)mob;
                ravager.goalSelector.addGoal(4, (Goal)new FindAndMoveToHilichurlCampfireGoal((Mob)ravager, speedModifierToCampfire * 1.2, searchRadiusForCampfire + 10));
                ravager.goalSelector.addGoal(2, (Goal)new BreakHilichurlCampfireGoal((Mob)ravager, timeToBreakCampfire / 2));
            }
        }
    }
}

