/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.event;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.zenith.hoyocraft.entity.ModEntities;
import net.zenith.hoyocraft.entity.spawn.GenshinEntityGroupSpawner;
import net.zenith.hoyocraft.entity.spawn.GenshinEntitySpawnRules;
import net.zenith.hoyocraft.entity.spawn.GroupSpawnConfig;
import net.zenith.hoyocraft.entity.spawn.SpawnRuleConfig;

@EventBusSubscriber(modid="hoyocraft", bus=EventBusSubscriber.Bus.MOD)
public class ModSpawnEvents {
    public static <T extends Monster> boolean checkCommonOverworldMonsterSpawns(EntityType<T> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.COMMAND || spawnType == MobSpawnType.DISPENSER) {
            return true;
        }
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        return Monster.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        System.out.println("ModSpawnEvents: ===== REGISTER SPAWN PLACEMENTS EVENT CALLED =====");
        event.register(ModEntities.FINCH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.HILICHURL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GenshinEntitySpawnRules::checkEntitySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.HYDRO_SLIME.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GenshinEntitySpawnRules::checkEntitySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.GEO_SLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GenshinEntitySpawnRules::checkEntitySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.PYRO_SLIME.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GenshinEntitySpawnRules::checkEntitySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.DENDRO_SLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GenshinEntitySpawnRules::checkEntitySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.ANEMO_SLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GenshinEntitySpawnRules::checkEntitySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.CRYO_SLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GenshinEntitySpawnRules::checkEntitySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ModEntities.ELECTRO_SLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GenshinEntitySpawnRules::checkEntitySpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        ModSpawnEvents.setupSpawnRuleConfigs();
        ModSpawnEvents.setupGroupSpawnConfigs();
    }

    private static void setupGroupSpawnConfigs() {
        System.out.println("ModSpawnEvents: ===== SETTING UP EPIC GROUP SPAWN CONFIGURATIONS! =====");
        GenshinEntityGroupSpawner.registerGroupSpawnConfig(ModEntities.HILICHURL.get(), new GroupSpawnConfig().setMinFollowers(3).setMaxFollowers(5).addFollowerType(ModEntities.HILICHURL.get(), 30).addFollowerType(ModEntities.HILICHURL_FIGHTER.get(), 70).setSpawnRadius(8).setRequireSolidGround(true).setAvoidLeaves(true).setMinimumLightLevel(8));
        System.out.println("ModSpawnEvents: Group spawn configurations complete!");
    }

    private static void setupSpawnRuleConfigs() {
        System.out.println("ModSpawnEvents: Setting up REVOLUTIONARY spawn rule configurations!");
        GenshinEntitySpawnRules.registerSpawnRules(ModEntities.HILICHURL.get(), new SpawnRuleConfig().setTimeRequirement(SpawnRuleConfig.TimeRequirement.DAYTIME_ONLY).setHeightRequirement(SpawnRuleConfig.HeightRequirement.SURFACE_ONLY).setMinLightLevel(8).setRequireSolidGround(true).setAvoidLeaves(true));
        GenshinEntitySpawnRules.registerSpawnRules(ModEntities.HYDRO_SLIME.get(), new SpawnRuleConfig().setTimeRequirement(SpawnRuleConfig.TimeRequirement.ANY_TIME).setNoHeightRestriction().setLightLevel(0, 15).setAllowWaterSpawning(true).setRequireSolidGround(false).setAvoidLeaves(false).setRequiredBlocks(Blocks.WATER));
        GenshinEntitySpawnRules.registerSpawnRules(ModEntities.GEO_SLIME.get(), new SpawnRuleConfig().setTimeRequirement(SpawnRuleConfig.TimeRequirement.ANY_TIME).setNoHeightRestriction().setLightLevel(0, 15).setRequiredBlocks(Blocks.STONE, Blocks.DEEPSLATE, Blocks.TUFF, Blocks.GRAVEL, Blocks.DIRT, Blocks.SANDSTONE, Blocks.COAL_ORE, Blocks.IRON_ORE, Blocks.GRANITE, Blocks.ANDESITE, Blocks.MOSS_BLOCK, Blocks.MOSS_CARPET, Blocks.CLAY).setRequireSolidGround(true));
        GenshinEntitySpawnRules.registerSpawnRules(ModEntities.PYRO_SLIME.get(), new SpawnRuleConfig().setTimeRequirement(SpawnRuleConfig.TimeRequirement.ANY_TIME).setNoHeightRestriction().setAllowLavaSpawning(true).setRequireSolidGround(false).setLightLevel(0, 15).setRequiredBlocks(Blocks.LAVA));
        GenshinEntitySpawnRules.registerSpawnRules(ModEntities.DENDRO_SLIME.get(), new SpawnRuleConfig().setTimeRequirement(SpawnRuleConfig.TimeRequirement.DAYTIME_ONLY).setHeightRequirement(SpawnRuleConfig.HeightRequirement.SURFACE_ONLY).setMinLightLevel(8).setRequiredBlocks(Blocks.GRASS_BLOCK, Blocks.DIRT, Blocks.SHORT_GRASS, Blocks.TALL_GRASS).setRequireSolidGround(true));
        GenshinEntitySpawnRules.registerSpawnRules(ModEntities.ANEMO_SLIME.get(), new SpawnRuleConfig().setTimeRequirement(SpawnRuleConfig.TimeRequirement.ANY_TIME).setHeightRequirement(SpawnRuleConfig.HeightRequirement.SURFACE_ONLY).setMinLightLevel(4).setRequireSolidGround(true).setAvoidLeaves(true));
        GenshinEntitySpawnRules.registerSpawnRules(ModEntities.CRYO_SLIME.get(), new SpawnRuleConfig().setTimeRequirement(SpawnRuleConfig.TimeRequirement.ANY_TIME).setNoHeightRestriction().setLightLevel(0, 15).setRequireSolidGround(true).setAvoidLeaves(true).setRequiredBlocks(Blocks.ICE, Blocks.PACKED_ICE, Blocks.BLUE_ICE, Blocks.FROSTED_ICE, Blocks.SNOW_BLOCK, Blocks.POWDER_SNOW, Blocks.GRASS_BLOCK, Blocks.DIRT, Blocks.STONE, Blocks.DEEPSLATE, Blocks.SAND, Blocks.GRAVEL));
        GenshinEntitySpawnRules.registerSpawnRules(ModEntities.ELECTRO_SLIME.get(), new SpawnRuleConfig().setTimeRequirement(SpawnRuleConfig.TimeRequirement.ANY_TIME).setHeightRequirement(SpawnRuleConfig.HeightRequirement.SURFACE_ONLY).setRequireSkyAccess(true).setMinLightLevel(4).setRequireSolidGround(true).setAvoidLeaves(true));
        System.out.println("ModSpawnEvents: Spawn rule configurations complete!");
    }
}

