/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.invasion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public record IncursionPattern(String incursionName, String announcementTitle, Optional<Integer> triggerDay, int portalCount, int portalSpawnIntervalTicks, int nodeCount, int spawnRadius, int waveIntervalTicks, List<IncursionWave> waves, BossBarSettings bossBar, SoundSettings sounds) {
    public static final Codec<IncursionPattern> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(IncursionPattern::incursionName), (App)Codec.STRING.optionalFieldOf("announcement_title", (Object)"Abyssal Incursion").forGetter(IncursionPattern::announcementTitle), (App)Codec.INT.optionalFieldOf("trigger_day").forGetter(IncursionPattern::triggerDay), (App)Codec.INT.fieldOf("portal_count").forGetter(IncursionPattern::portalCount), (App)Codec.INT.optionalFieldOf("portal_spawn_interval_ticks", (Object)0).forGetter(IncursionPattern::portalSpawnIntervalTicks), (App)Codec.INT.fieldOf("node_count").forGetter(IncursionPattern::nodeCount), (App)Codec.INT.fieldOf("spawn_radius").forGetter(IncursionPattern::spawnRadius), (App)Codec.INT.fieldOf("wave_interval_ticks").forGetter(IncursionPattern::waveIntervalTicks), (App)IncursionWave.CODEC.listOf().fieldOf("waves").forGetter(IncursionPattern::waves), (App)BossBarSettings.CODEC.optionalFieldOf("boss_bar").forGetter(p -> Optional.of(p.bossBar())), (App)SoundSettings.CODEC.optionalFieldOf("sounds").forGetter(p -> Optional.of(p.sounds()))).apply((Applicative)instance, (name, announcement, triggerDay, portals, portalInterval, nodes, radius, interval, waves, bossBar, sounds) -> new IncursionPattern((String)name, (String)announcement, (Optional<Integer>)triggerDay, (int)portals, (int)portalInterval, (int)nodes, (int)radius, (int)interval, (List<IncursionWave>)waves, bossBar.orElse(BossBarSettings.DEFAULT), sounds.orElse(SoundSettings.DEFAULT))));

    public record BossBarSettings(String title, String color, String overlay) {
        public static final Codec<BossBarSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("title").forGetter(BossBarSettings::title), (App)Codec.STRING.fieldOf("color").forGetter(BossBarSettings::color), (App)Codec.STRING.fieldOf("overlay").forGetter(BossBarSettings::overlay)).apply((Applicative)instance, BossBarSettings::new));
        public static final BossBarSettings DEFAULT = new BossBarSettings("Abyssal Incursion", "red", "progress");
    }

    public record SoundSettings(Optional<ResourceLocation> startSound, Optional<ResourceLocation> successSound, Optional<ResourceLocation> failureSound) {
        public static final Codec<SoundSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("start_sound").forGetter(SoundSettings::startSound), (App)ResourceLocation.CODEC.optionalFieldOf("success_sound").forGetter(SoundSettings::successSound), (App)ResourceLocation.CODEC.optionalFieldOf("failure_sound").forGetter(SoundSettings::failureSound)).apply((Applicative)instance, SoundSettings::new));
        public static final SoundSettings DEFAULT = new SoundSettings(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public record IncursionWave(List<SpawnInfo> spawns) {
        public static final Codec<IncursionWave> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpawnInfo.CODEC.listOf().fieldOf("spawns").forGetter(IncursionWave::spawns)).apply((Applicative)instance, IncursionWave::new));
    }

    public record SpawnInfo(ResourceLocation entityId, int minCount, int maxCount) {
        public static final Codec<SpawnInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("entity").forGetter(SpawnInfo::entityId), (App)Codec.INT.fieldOf("min_count").forGetter(SpawnInfo::minCount), (App)Codec.INT.fieldOf("max_count").forGetter(SpawnInfo::maxCount)).apply((Applicative)instance, SpawnInfo::new));
    }
}

