/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.invasion;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.zenith.hoyocraft.invasion.IncursionPattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IncursionPatternManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DIRECTORY = "incursions";
    private static IncursionPatternManager instance;
    private Map<ResourceLocation, IncursionPattern> patterns = new HashMap<ResourceLocation, IncursionPattern>();

    public IncursionPatternManager() {
        super(GSON, DIRECTORY);
    }

    public static IncursionPatternManager getInstance() {
        if (instance == null) {
            instance = new IncursionPatternManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, IncursionPattern> loadedPatterns = new HashMap<ResourceLocation, IncursionPattern>();
        object.forEach((id, jsonElement) -> {
            DataResult dataResult = IncursionPattern.CODEC.decode((DynamicOps)JsonOps.INSTANCE, jsonElement);
            dataResult.result().ifPresentOrElse(pair -> {
                loadedPatterns.put((ResourceLocation)id, (IncursionPattern)pair.getFirst());
                LOGGER.info("Successfully loaded incursion pattern: {}", id);
            }, () -> dataResult.error().ifPresent(error -> LOGGER.error("Failed to parse incursion pattern {}: {}", id, (Object)error.message())));
        });
        this.patterns = loadedPatterns;
        LOGGER.info("Loaded {} incursion patterns.", (Object)this.patterns.size());
    }

    public Optional<IncursionPattern> getPattern(ResourceLocation id) {
        return Optional.ofNullable(this.patterns.get(id));
    }

    public Map<ResourceLocation, IncursionPattern> getTimedPatterns() {
        return this.patterns.entrySet().stream().filter(entry -> ((IncursionPattern)entry.getValue()).triggerDay().isPresent()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<ResourceLocation, IncursionPattern> getAllPatterns() {
        return Collections.unmodifiableMap(this.patterns);
    }
}

