/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.invasion;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class InvasionSavedData
extends SavedData {
    private static final String DATA_NAME = "hoyocraft_incursion_state";
    public long lastInvasionTime = 0L;
    public boolean invasionsStopped = false;
    public boolean invasionActive = false;
    public Optional<ResourceLocation> activeIncursionPatternId = Optional.empty();
    public int totalPortals = 0;
    public int activePortals = 0;
    public List<UUID> activePortalUUIDs = new ArrayList<UUID>();
    public int portalsToSpawn = 0;
    public int nextPortalSpawnCooldown = 0;
    public int portalsEverSpawned = 0;
    public static final SavedData.Factory<InvasionSavedData> FACTORY = new SavedData.Factory(InvasionSavedData::new, InvasionSavedData::load, null);

    public static InvasionSavedData load(CompoundTag tag, HolderLookup.Provider registries) {
        InvasionSavedData data = new InvasionSavedData();
        data.lastInvasionTime = tag.getLong("lastInvasionTime");
        data.invasionsStopped = tag.getBoolean("invasionsStopped");
        data.invasionActive = tag.getBoolean("invasionActive");
        if (tag.contains("activeIncursionPatternId")) {
            data.activeIncursionPatternId = Optional.of(ResourceLocation.parse((String)tag.getString("activeIncursionPatternId")));
        }
        data.totalPortals = tag.getInt("totalPortals");
        data.activePortals = tag.getInt("activePortals");
        if (tag.contains("activePortalUUIDs", 9)) {
            ListTag listTag = tag.getList("activePortalUUIDs", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                data.activePortalUUIDs.add(UUID.fromString(listTag.getString(i)));
            }
        }
        data.portalsToSpawn = tag.getInt("portalsToSpawn");
        data.nextPortalSpawnCooldown = tag.getInt("nextPortalSpawnCooldown");
        data.portalsEverSpawned = tag.getInt("portalsEverSpawned");
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("lastInvasionTime", this.lastInvasionTime);
        tag.putBoolean("invasionsStopped", this.invasionsStopped);
        tag.putBoolean("invasionActive", this.invasionActive);
        this.activeIncursionPatternId.ifPresent(id -> tag.putString("activeIncursionPatternId", id.toString()));
        tag.putInt("totalPortals", this.totalPortals);
        tag.putInt("activePortals", this.activePortals);
        ListTag listTag = new ListTag();
        for (UUID uuid : this.activePortalUUIDs) {
            listTag.add((Object)StringTag.valueOf((String)uuid.toString()));
        }
        tag.put("activePortalUUIDs", (Tag)listTag);
        tag.putInt("portalsToSpawn", this.portalsToSpawn);
        tag.putInt("nextPortalSpawnCooldown", this.nextPortalSpawnCooldown);
        tag.putInt("portalsEverSpawned", this.portalsEverSpawned);
        return tag;
    }

    public void resetActiveInvasion() {
        this.invasionActive = false;
        this.activeIncursionPatternId = Optional.empty();
        this.totalPortals = 0;
        this.activePortals = 0;
        this.activePortalUUIDs.clear();
        this.portalsToSpawn = 0;
        this.nextPortalSpawnCooldown = 0;
        this.portalsEverSpawned = 0;
        this.setDirty();
    }

    public static InvasionSavedData get(ServerLevel level) {
        DimensionDataStorage storage = level.getServer().overworld().getDataStorage();
        return (InvasionSavedData)storage.computeIfAbsent(FACTORY, DATA_NAME);
    }
}

