/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.zenith.hoyocraft.component.ModDataComponents;
import net.zenith.hoyocraft.entity.ModEntities;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class CustomEntitySpawnItem
extends Item {
    private final EntityType<?> entityTypeToSpawn;

    public CustomEntitySpawnItem(EntityType<?> entityTypeToSpawn, Item.Properties pProperties) {
        super(pProperties);
        this.entityTypeToSpawn = entityTypeToSpawn;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = pContext.getItemInHand();
        BlockPos blockpos = pContext.getClickedPos();
        boolean spawnAsLeader = (Boolean)itemstack.getOrDefault((DataComponentType)ModDataComponents.SPAWN_EGG_LEADER_MODE.get(), (Object)false);
        Entity entity = this.entityTypeToSpawn.spawn((ServerLevel)level, itemstack, pContext.getPlayer(), blockpos.relative(pContext.getClickedFace()), MobSpawnType.SPAWN_EGG, true, false);
        if (entity != null) {
            LivingEntity livingEntity;
            if (entity instanceof GenshinEntity) {
                GenshinEntity genshinEntity = (GenshinEntity)entity;
                genshinEntity.setLeader(spawnAsLeader);
            }
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
            }
            if (entity instanceof Mob) {
                livingEntity = (Mob)entity;
            }
            itemstack.shrink(1);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!this.canHaveLeaderMode()) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                boolean currentModeIsLeader = (Boolean)itemStack.getOrDefault((DataComponentType)ModDataComponents.SPAWN_EGG_LEADER_MODE.get(), (Object)false);
                boolean newModeIsLeader = !currentModeIsLeader;
                itemStack.set((DataComponentType)ModDataComponents.SPAWN_EGG_LEADER_MODE.get(), (Object)newModeIsLeader);
                if (newModeIsLeader) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.hoyocraft.spawn_egg.mode_leader"));
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.hoyocraft.spawn_egg.mode_normal"));
                }
            }
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.canHaveLeaderMode()) {
            boolean isLeaderMode = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.SPAWN_EGG_LEADER_MODE.get(), (Object)false);
            MutableComponent modeText = isLeaderMode ? Component.translatable((String)"tooltip.hoyocraft.spawn_egg.leader").withStyle(ChatFormatting.GOLD) : Component.translatable((String)"tooltip.hoyocraft.spawn_egg.normal").withStyle(ChatFormatting.AQUA);
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hoyocraft.spawn_egg.mode", (Object[])new Object[]{modeText}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hoyocraft.spawn_egg.instruction").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    private boolean canHaveLeaderMode() {
        return this.entityTypeToSpawn != ModEntities.HYDRO_SLIME.get() && this.entityTypeToSpawn != ModEntities.PYRO_SLIME.get() && this.entityTypeToSpawn != ModEntities.ELECTRO_SLIME.get() && this.entityTypeToSpawn != ModEntities.ANEMO_SLIME.get() && this.entityTypeToSpawn != ModEntities.CRYO_SLIME.get() && this.entityTypeToSpawn != ModEntities.GEO_SLIME.get() && this.entityTypeToSpawn != ModEntities.DENDRO_SLIME.get() && this.entityTypeToSpawn != ModEntities.FINCH.get();
    }
}

