/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.network;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.zenith.hoyocraft.network.packet.EntityStateSyncPacket;
import net.zenith.hoyocraft.network.packet.IncursionWaveClearPacket;
import net.zenith.hoyocraft.network.packet.InvasionStateSyncPacket;
import net.zenith.hoyocraft.network.packet.PortalSpawnMobPacket;

public class ModNetworking {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("hoyocraft_v1");
        registrar.playToClient(EntityStateSyncPacket.TYPE, EntityStateSyncPacket.STREAM_CODEC, EntityStateSyncPacket.Handler::handle);
        registrar.playToClient(InvasionStateSyncPacket.TYPE, InvasionStateSyncPacket.STREAM_CODEC, InvasionStateSyncPacket.Handler::handle);
        registrar.playToClient(PortalSpawnMobPacket.TYPE, PortalSpawnMobPacket.STREAM_CODEC, PortalSpawnMobPacket.Handler::handle);
        registrar.playToClient(IncursionWaveClearPacket.TYPE, IncursionWaveClearPacket.STREAM_CODEC, IncursionWaveClearPacket.Handler::handle);
    }

    public static void sendPortalSpawnMobEvent(int portalIndex) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PortalSpawnMobPacket(portalIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendEntityStateSync(Entity entity, int tauntState, boolean sprinting, boolean attackingGeckoLib, boolean leftCircling, boolean isJumpingAttack) {
        System.out.println("ModNetworking: Sending state sync for entity " + entity.getId() + " (" + entity.getType().toString() + "). Taunt=" + tauntState + ", Sprint=" + sprinting + ", AttackingGL=" + attackingGeckoLib + ", LeftCircle=" + leftCircling + ", IsJumping=" + isJumpingAttack);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new EntityStateSyncPacket(entity.getId(), tauntState, sprinting, attackingGeckoLib, leftCircling, isJumpingAttack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendInvasionStateSync(boolean invasionActive, int activePortals, int totalPortals, int portalsEverSpawned) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new InvasionStateSyncPacket(invasionActive, activePortals, totalPortals, portalsEverSpawned), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendIncursionWaveClearEvent(int portalIndex) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new IncursionWaveClearPacket(portalIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

