/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.network.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.zenith.hoyocraft.entity.core.combat.ITauntableGenshinEntity;

public record EntityStateSyncPacket(int entityId, int tauntState, boolean isSprinting, boolean isAttacking, boolean isCirclingLeft, boolean isJumpingAttack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EntityStateSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"entity_state_sync"));
    public static final StreamCodec<FriendlyByteBuf, EntityStateSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, EntityStateSyncPacket::entityId, (StreamCodec)ByteBufCodecs.VAR_INT, EntityStateSyncPacket::tauntState, (StreamCodec)ByteBufCodecs.BOOL, EntityStateSyncPacket::isSprinting, (StreamCodec)ByteBufCodecs.BOOL, EntityStateSyncPacket::isAttacking, (StreamCodec)ByteBufCodecs.BOOL, EntityStateSyncPacket::isCirclingLeft, (StreamCodec)ByteBufCodecs.BOOL, EntityStateSyncPacket::isJumpingAttack, EntityStateSyncPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler {
        public static void handle(EntityStateSyncPacket data, IPayloadContext context) {
            context.enqueueWork(() -> {
                Entity entity = context.player().level().getEntity(data.entityId());
                if (entity instanceof ITauntableGenshinEntity) {
                    ITauntableGenshinEntity tauntable = (ITauntableGenshinEntity)entity;
                    tauntable.setTauntState(data.tauntState());
                    tauntable.setSprinting(data.isSprinting());
                    tauntable.setAttackingGeckoLib(data.isAttacking());
                    tauntable.setLeftCircling(data.isCirclingLeft());
                    tauntable.setJumpingAttack(data.isJumpingAttack());
                }
            });
        }
    }
}

