/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.network.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.zenith.hoyocraft.client.ClientInvasionState;

public record InvasionStateSyncPacket(boolean invasionActive, int activePortals, int totalPortals, int portalsEverSpawned) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InvasionStateSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"invasion_state_sync"));
    public static final StreamCodec<FriendlyByteBuf, InvasionStateSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, InvasionStateSyncPacket::invasionActive, (StreamCodec)ByteBufCodecs.INT, InvasionStateSyncPacket::activePortals, (StreamCodec)ByteBufCodecs.INT, InvasionStateSyncPacket::totalPortals, (StreamCodec)ByteBufCodecs.INT, InvasionStateSyncPacket::portalsEverSpawned, InvasionStateSyncPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler {
        public static void handle(InvasionStateSyncPacket data, IPayloadContext context) {
            context.enqueueWork(() -> {
                ClientInvasionState.setInvasionActive(data.invasionActive());
                ClientInvasionState.setActivePortals(data.activePortals());
                ClientInvasionState.setTotalPortals(data.totalPortals());
                ClientInvasionState.setPortalsEverSpawned(data.portalsEverSpawned());
            });
        }
    }
}

