/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.network.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.zenith.hoyocraft.client.ClientInvasionState;

public record PortalSpawnMobPacket(int portalIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PortalSpawnMobPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"portal_spawn_mob"));
    public static final StreamCodec<FriendlyByteBuf, PortalSpawnMobPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PortalSpawnMobPacket::portalIndex, PortalSpawnMobPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler {
        public static void handle(PortalSpawnMobPacket data, IPayloadContext context) {
            context.enqueueWork(() -> ClientInvasionState.triggerPortalSpawnAnim(data.portalIndex()));
        }
    }
}

