/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.worldgen.camp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.zenith.hoyocraft.block.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class CampContributionPlacer {
    private static final int MIN_FENCE_DISTANCE_FROM_ANCHOR = 12;
    private static final int MAX_FENCE_DISTANCE_FROM_ANCHOR = 20;
    private static final int MIN_FENCE_LENGTH = 3;
    private static final int MAX_FENCE_LENGTH = 6;
    private static final int MIN_TOTAL_L_SHAPE_LENGTH = 3;
    private static final int MAX_TOTAL_L_SHAPE_LENGTH = 6;
    private static final int MIN_SINGLE_SEGMENT_LENGTH = 2;
    private static final int MIN_TOTAL_U_SHAPE_LENGTH = 4;
    private static final int MAX_TOTAL_U_SHAPE_LENGTH = 8;
    private static final int MIN_U_ARM_LENGTH = 2;
    private static final int MIN_U_BASE_LENGTH = 2;
    private static final Block FENCE_BLOCK_TYPE = Blocks.OAK_FENCE;
    private static final List<EntityType<? extends Animal>> SPAWNABLE_ANIMAL_TYPES = List.of(EntityType.COW, EntityType.PIG, EntityType.SHEEP, EntityType.CHICKEN);

    public static boolean tryPlaceHayBale(ServerLevel level, BlockPos anchorPos, RandomSource random) {
        BlockPos placementPos = CampContributionPlacer.findClearPlacementPosNearby(level, anchorPos, 1, 1, 1, 10, random);
        if (placementPos != null) {
            level.setBlock(placementPos, Blocks.HAY_BLOCK.defaultBlockState(), 3);
            level.playSound(null, placementPos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean trySpawnLeashedAnimal(ServerLevel level, BlockPos anchorPos, RandomSource random) {
        if (SPAWNABLE_ANIMAL_TYPES.isEmpty()) {
            return false;
        }
        BlockPos animalSpawnPos = null;
        BlockPos fencePostPos = null;
        int placementAttempts = 0;
        block0: while ((animalSpawnPos == null || fencePostPos == null) && placementAttempts < 10) {
            ++placementAttempts;
            BlockPos potentialAnimalArea = CampContributionPlacer.findClearPlacementPosNearby(level, anchorPos, 2, 2, 3, 7, random);
            if (potentialAnimalArea == null) continue;
            ArrayList<Direction> horizontalDirections = new ArrayList<Direction>(List.of((Direction[])Direction.Plane.HORIZONTAL.stream().toArray(Direction[]::new)));
            Collections.shuffle(horizontalDirections, new Random(random.nextLong()));
            for (Direction dir : horizontalDirections) {
                BlockPos groundAnimalPos;
                BlockPos potentialFencePos = potentialAnimalArea.relative(dir);
                if (!level.getBlockState(potentialFencePos.below()).isFaceSturdy((BlockGetter)level, potentialFencePos.below(), Direction.UP) || !level.isEmptyBlock(potentialFencePos) || !level.isEmptyBlock(potentialFencePos.above()) || !level.getBlockState((groundAnimalPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, potentialAnimalArea)).below()).isFaceSturdy((BlockGetter)level, groundAnimalPos.below(), Direction.UP) || !level.isEmptyBlock(groundAnimalPos)) continue;
                animalSpawnPos = groundAnimalPos;
                fencePostPos = potentialFencePos;
                continue block0;
            }
        }
        if (animalSpawnPos == null || fencePostPos == null) {
            return false;
        }
        EntityType<? extends Animal> selectedAnimalType = SPAWNABLE_ANIMAL_TYPES.get(random.nextInt(SPAWNABLE_ANIMAL_TYPES.size()));
        Animal animalEntity = (Animal)selectedAnimalType.create((Level)level);
        if (animalEntity != null) {
            animalEntity.moveTo((double)animalSpawnPos.getX() + 0.5, (double)animalSpawnPos.getY(), (double)animalSpawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            if (animalEntity instanceof AgeableMob) {
                Animal ageableMob = animalEntity;
                ageableMob.setAge(0);
            }
            level.setBlock(fencePostPos, FENCE_BLOCK_TYPE.defaultBlockState(), 3);
            LeashFenceKnotEntity leashKnotEntity = LeashFenceKnotEntity.getOrCreateKnot((Level)level, fencePostPos);
            if (leashKnotEntity == null) {
                level.destroyBlock(fencePostPos, false);
                if (animalEntity != null) {
                    animalEntity.discard();
                }
                return false;
            }
            level.addFreshEntity((Entity)animalEntity);
            animalEntity.setLeashedTo((Entity)leashKnotEntity, true);
            SoundEvent ambientSound = SoundEvents.CHICKEN_AMBIENT;
            if (selectedAnimalType == EntityType.COW) {
                ambientSound = SoundEvents.COW_AMBIENT;
            } else if (selectedAnimalType == EntityType.PIG) {
                ambientSound = SoundEvents.PIG_AMBIENT;
            } else if (selectedAnimalType == EntityType.SHEEP) {
                ambientSound = SoundEvents.SHEEP_AMBIENT;
            }
            level.playSound(null, animalSpawnPos, ambientSound, SoundSource.NEUTRAL, 0.7f, animalEntity.getVoicePitch());
            level.playSound(null, fencePostPos, SoundEvents.LEASH_KNOT_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean tryPlaceLogPile(ServerLevel level, BlockPos anchorPos, RandomSource random) {
        Block logBlock = Blocks.OAK_LOG;
        int numberOfLogs = 2 + random.nextInt(2);
        for (int attempt = 0; attempt < 10; ++attempt) {
            Direction.Axis primaryAxis = random.nextBoolean() ? Direction.Axis.X : Direction.Axis.Z;
            BlockState logStateWithAxis = (BlockState)logBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)primaryAxis);
            Direction extensionDirection = Direction.fromAxisAndDirection((Direction.Axis)primaryAxis, (Direction.AxisDirection)(random.nextBoolean() ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
            BlockPos firstLogPos = CampContributionPlacer.findClearPlacementPosNearby(level, anchorPos, 1, 1, 2, 6, random);
            if (firstLogPos == null || firstLogPos.distManhattan((Vec3i)anchorPos) < 2) continue;
            ArrayList<BlockPos> logPositionsToPlace = new ArrayList<BlockPos>();
            boolean canPlaceEntireLogPile = true;
            for (int i = 0; i < numberOfLogs; ++i) {
                BlockPos currentLogPos = firstLogPos.relative(extensionDirection, i);
                if (i == 0) {
                    if (level.getBlockState(currentLogPos.below()).isFaceSturdy((BlockGetter)level, currentLogPos.below(), Direction.UP) && level.isEmptyBlock(currentLogPos)) {
                        logPositionsToPlace.add(currentLogPos);
                        continue;
                    }
                    canPlaceEntireLogPile = false;
                    break;
                }
                if (level.getBlockState(currentLogPos.below()).isFaceSturdy((BlockGetter)level, currentLogPos.below(), Direction.UP) && level.isEmptyBlock(currentLogPos)) {
                    logPositionsToPlace.add(currentLogPos);
                    continue;
                }
                canPlaceEntireLogPile = false;
                break;
            }
            if (!canPlaceEntireLogPile || logPositionsToPlace.isEmpty()) continue;
            for (BlockPos pos : logPositionsToPlace) {
                level.setBlock(pos, logStateWithAxis, 3);
            }
            level.playSound(null, firstLogPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            return true;
        }
        return false;
    }

    public static boolean tryPlaceLargeCrate(ServerLevel level, BlockPos anchorPos, RandomSource random) {
        BlockPos placementPos = CampContributionPlacer.findClearPlacementPosNearby(level, anchorPos, 1, 2, 5, 20, random);
        if (placementPos != null) {
            level.setBlock(placementPos, ModBlocks.LARGE_CRATE.get().defaultBlockState(), 3);
            level.playSound(null, placementPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f);
            return true;
        }
        return false;
    }

    public static boolean tryPlaceHilichurlBarrel(ServerLevel level, BlockPos anchorPos, RandomSource random) {
        BlockPos placementPos = CampContributionPlacer.findClearPlacementPosNearby(level, anchorPos, 1, 1, 4, 18, random);
        if (placementPos != null) {
            level.setBlock(placementPos, ModBlocks.HILICHURL_BARREL.get().defaultBlockState(), 3);
            level.playSound(null, placementPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f);
            return true;
        }
        return false;
    }

    public static boolean tryPlaceFence(ServerLevel level, BlockPos anchorPos, RandomSource random, FenceShape shape) {
        int attempts = 0;
        int maxAttempts = 3;
        for (attempts = 0; attempts < maxAttempts; ++attempts) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            int distance = 12 + random.nextInt(9);
            int xOffset = (int)(Math.cos(angle) * (double)distance);
            int zOffset = (int)(Math.sin(angle) * (double)distance);
            BlockPos potentialStartPointInRing = anchorPos.offset(xOffset, 0, zOffset);
            BlockPos fenceLineStartPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, potentialStartPointInRing);
            Direction initialFenceDirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            boolean successThisAttempt = false;
            if (shape == FenceShape.STRAIGHT) {
                int length = 3 + random.nextInt(4);
                successThisAttempt = CampContributionPlacer.staticTryPlaceFenceLine(level, fenceLineStartPos, initialFenceDirection, length, FENCE_BLOCK_TYPE, anchorPos, null) != null;
            } else if (shape == FenceShape.L_SHAPE) {
                successThisAttempt = CampContributionPlacer.staticTryPlaceLShapeFence(level, fenceLineStartPos, initialFenceDirection, random, anchorPos);
            } else if (shape == FenceShape.U_SHAPE) {
                successThisAttempt = CampContributionPlacer.staticTryPlaceUShapeFence(level, fenceLineStartPos, initialFenceDirection, random, anchorPos);
            } else if (shape == FenceShape.ZIG_ZAG) {
                successThisAttempt = CampContributionPlacer.staticTryPlaceZigZagFence(level, fenceLineStartPos, initialFenceDirection, random, anchorPos);
            }
            if (!successThisAttempt) continue;
            level.playSound(null, fenceLineStartPos, SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS, 0.8f, 1.0f + random.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    @Nullable
    private static BlockPos staticTryPlaceFenceLine(ServerLevel level, BlockPos lineStartGroundPos, Direction direction, int length, Block fenceBlock, BlockPos campCenter, @Nullable BlockPos segmentToConnectTo) {
        int requiredMin;
        if (length < 2 && (length <= 0 || segmentToConnectTo == null) && length < 1) {
            return null;
        }
        int fencesPlacedCount = 0;
        BlockPos lastSuccessfullyPlacedPos = null;
        BlockPos previousFenceActualPos = lineStartGroundPos.relative(direction.getOpposite(), 1);
        for (int i = 0; i < length; ++i) {
            int yDiff;
            BlockPos currentTargetAbstractPos = lineStartGroundPos.relative(direction, i);
            BlockPos currentPlacementActualPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, currentTargetAbstractPos);
            if (currentPlacementActualPos.distManhattan((Vec3i)campCenter) < 5 && i < 2 && segmentToConnectTo == null) {
                if (fencesPlacedCount >= 2) break;
                return lastSuccessfullyPlacedPos;
            }
            BlockState blockBelowState = level.getBlockState(currentPlacementActualPos.below());
            if (!blockBelowState.isFaceSturdy((BlockGetter)level, currentPlacementActualPos.below(), Direction.UP)) {
                if (fencesPlacedCount >= 2) break;
                if (i != 0 || fencesPlacedCount != 0) continue;
                return null;
            }
            BlockState currentBlockState = level.getBlockState(currentPlacementActualPos);
            if (!(currentBlockState.isAir() || currentBlockState.canBeReplaced() || currentBlockState.is(Blocks.SNOW) || currentBlockState.is(fenceBlock))) {
                if (fencesPlacedCount >= 2) break;
                if (i != 0 || fencesPlacedCount != 0) continue;
                return null;
            }
            if (!level.isEmptyBlock(currentPlacementActualPos.above()) && !level.getBlockState(currentPlacementActualPos.above()).is(fenceBlock)) {
                if (fencesPlacedCount >= 2) break;
                if (i != 0 || fencesPlacedCount != 0) continue;
                return null;
            }
            if ((fencesPlacedCount > 0 || i > 0 && previousFenceActualPos != null) && (yDiff = Math.abs(currentPlacementActualPos.getY() - previousFenceActualPos.getY())) > 1) break;
            if (!level.getBlockState(currentPlacementActualPos).is(fenceBlock)) {
                level.setBlock(currentPlacementActualPos, fenceBlock.defaultBlockState(), 3);
            }
            ++fencesPlacedCount;
            lastSuccessfullyPlacedPos = currentPlacementActualPos;
            previousFenceActualPos = currentPlacementActualPos;
        }
        int n = requiredMin = segmentToConnectTo != null && length == 1 ? 1 : 2;
        if (length == 1 && segmentToConnectTo == null) {
            requiredMin = 1;
        }
        return fencesPlacedCount >= requiredMin ? lastSuccessfullyPlacedPos : null;
    }

    private static boolean staticTryPlaceLShapeFence(ServerLevel level, BlockPos startPos, Direction initialDir, RandomSource random, BlockPos campCenter) {
        int totalLMaterial = 3 + random.nextInt(4);
        if (totalLMaterial < 4) {
            totalLMaterial = 4;
        }
        int firstSegLen = 2 + random.nextInt(Math.max(1, totalLMaterial - 4 + 1));
        int secondSegLen = totalLMaterial - firstSegLen;
        BlockPos endOfFirst = CampContributionPlacer.staticTryPlaceFenceLine(level, startPos, initialDir, firstSegLen, FENCE_BLOCK_TYPE, campCenter, null);
        if (endOfFirst == null) {
            return false;
        }
        Direction dirCw = initialDir.getClockWise();
        Direction dirCcw = initialDir.getCounterClockWise();
        BlockPos testPointCw = endOfFirst.relative(dirCw, 2);
        BlockPos testPointCcw = endOfFirst.relative(dirCcw, 2);
        Direction turnDir = testPointCw.distSqr((Vec3i)campCenter) <= testPointCcw.distSqr((Vec3i)campCenter) ? dirCw : dirCcw;
        BlockPos startOfSecondCandidate = endOfFirst.relative(turnDir, 1);
        BlockPos groundStartOfSecond = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startOfSecondCandidate);
        if (Math.abs(groundStartOfSecond.getY() - endOfFirst.getY()) > 1) {
            return true;
        }
        return CampContributionPlacer.staticTryPlaceFenceLine(level, groundStartOfSecond, turnDir, secondSegLen, FENCE_BLOCK_TYPE, campCenter, endOfFirst) != null;
    }

    private static boolean staticTryPlaceUShapeFence(ServerLevel level, BlockPos startPos, Direction initialDir, RandomSource random, BlockPos campCenter) {
        BlockPos endOfArm1;
        int totalUMaterial = 4 + random.nextInt(5);
        if (totalUMaterial < 6) {
            totalUMaterial = 6;
        }
        int baseLen = 2 + random.nextInt(Math.max(1, totalUMaterial - 6 + 1));
        baseLen = Math.min(baseLen, totalUMaterial - 4);
        int remainingForArms = totalUMaterial - baseLen;
        int arm1Len = 2 + random.nextInt(Math.max(1, remainingForArms - 4 + 1));
        int arm2Len = remainingForArms - (arm1Len = Math.min(arm1Len, remainingForArms - 2));
        if (arm2Len < 2) {
            int diff = 2 - arm2Len;
            arm2Len = 2;
            if ((arm1Len -= diff) < 2) {
                return false;
            }
        }
        if ((endOfArm1 = CampContributionPlacer.staticTryPlaceFenceLine(level, startPos, initialDir, arm1Len, FENCE_BLOCK_TYPE, campCenter, null)) == null) {
            return false;
        }
        Direction dirCw = initialDir.getClockWise();
        Direction dirCcw = initialDir.getCounterClockWise();
        BlockPos testPointCw = endOfArm1.relative(dirCw, 2);
        BlockPos testPointCcw = endOfArm1.relative(dirCcw, 2);
        Direction baseDir = testPointCw.distSqr((Vec3i)campCenter) <= testPointCcw.distSqr((Vec3i)campCenter) ? dirCw : dirCcw;
        BlockPos startOfBaseCandidate = endOfArm1.relative(baseDir, 1);
        BlockPos groundStartOfBase = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startOfBaseCandidate);
        if (Math.abs(groundStartOfBase.getY() - endOfArm1.getY()) > 1) {
            return true;
        }
        BlockPos endOfBase = CampContributionPlacer.staticTryPlaceFenceLine(level, groundStartOfBase, baseDir, baseLen, FENCE_BLOCK_TYPE, campCenter, endOfArm1);
        if (endOfBase == null) {
            return true;
        }
        Direction arm2Dir = initialDir;
        BlockPos startOfArm2Candidate = endOfBase.relative(arm2Dir, 1);
        BlockPos groundStartOfArm2 = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startOfArm2Candidate);
        if (Math.abs(groundStartOfArm2.getY() - endOfBase.getY()) > 1) {
            return true;
        }
        return CampContributionPlacer.staticTryPlaceFenceLine(level, groundStartOfArm2, arm2Dir, arm2Len, FENCE_BLOCK_TYPE, campCenter, endOfBase) != null;
    }

    private static boolean staticTryPlaceZigZagFence(ServerLevel level, BlockPos initialStartPos, Direction initialDirection, RandomSource random, BlockPos campCenter) {
        int maxSegmentsToPlace = 3 + random.nextInt(5);
        boolean segmentLength = true;
        int minSuccessfulSegments = 2;
        BlockPos currentSegmentEndPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, initialStartPos);
        Direction currentDirection = initialDirection;
        TurnType lastActualTurn = TurnType.NONE;
        int segmentsSuccessfullyPlaced = 0;
        for (int i = 0; i < maxSegmentsToPlace; ++i) {
            BlockPos segmentPlacedPos = CampContributionPlacer.staticTryPlaceFenceLine(level, currentSegmentEndPos, currentDirection, 1, FENCE_BLOCK_TYPE, campCenter, (BlockPos)(segmentsSuccessfullyPlaced > 0 ? currentSegmentEndPos : null));
            if (segmentPlacedPos == null) {
                if (i != 0) break;
                return false;
            }
            ++segmentsSuccessfullyPlaced;
            currentSegmentEndPos = segmentPlacedPos;
            if (i == maxSegmentsToPlace - 1) break;
            ArrayList<TurnType> availableNextTurns = new ArrayList<TurnType>();
            if (lastActualTurn != TurnType.LEFT) {
                availableNextTurns.add(TurnType.LEFT);
            }
            if (lastActualTurn != TurnType.RIGHT) {
                availableNextTurns.add(TurnType.RIGHT);
            }
            availableNextTurns.add(TurnType.STRAIGHT);
            if (availableNextTurns.isEmpty()) break;
            TurnType chosenTurn = (TurnType)((Object)availableNextTurns.get(random.nextInt(availableNextTurns.size())));
            if (chosenTurn == TurnType.LEFT) {
                currentDirection = currentDirection.getCounterClockWise();
                lastActualTurn = TurnType.LEFT;
            } else if (chosenTurn == TurnType.RIGHT) {
                currentDirection = currentDirection.getClockWise();
                lastActualTurn = TurnType.RIGHT;
            } else {
                lastActualTurn = TurnType.STRAIGHT;
            }
            BlockPos nextPotentialStartPos = currentSegmentEndPos.relative(currentDirection);
            BlockPos nextSegmentGroundStartPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, nextPotentialStartPos);
            if (Math.abs(nextSegmentGroundStartPos.getY() - currentSegmentEndPos.getY()) > 1) break;
            currentSegmentEndPos = nextSegmentGroundStartPos;
        }
        return segmentsSuccessfullyPlaced >= 2;
    }

    @Nullable
    private static BlockPos findClearPlacementPosNearby(ServerLevel level, BlockPos anchorPos, int objectWidth, int objectHeight, int minRadius, int maxRadius, RandomSource random) {
        if (maxRadius <= minRadius && maxRadius > 0) {
            minRadius = maxRadius - 1;
        } else if (maxRadius <= minRadius) {
            maxRadius = minRadius + 1;
        }
        for (int attempts = 0; attempts < 15; ++attempts) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double dist = minRadius == 0 && maxRadius == 0 ? 0.0 : (double)minRadius + random.nextDouble() * (double)(maxRadius - minRadius);
            int xOff = (int)(Math.cos(angle) * dist);
            int zOff = (int)(Math.sin(angle) * dist);
            BlockPos potentialCenterPos = anchorPos.offset(xOff, 0, zOff);
            BlockPos groundPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, potentialCenterPos);
            boolean spaceClear = true;
            for (int yOffset = 0; yOffset < objectHeight; ++yOffset) {
                if (level.isEmptyBlock(groundPos.above(yOffset))) continue;
                spaceClear = false;
                break;
            }
            if (objectHeight == 1 && !level.isEmptyBlock(groundPos) && !level.getBlockState(groundPos).canBeReplaced()) {
                spaceClear = false;
            }
            if (!spaceClear || !level.getBlockState(groundPos.below()).isFaceSturdy((BlockGetter)level, groundPos.below(), Direction.UP) || groundPos.equals((Object)anchorPos)) continue;
            return groundPos;
        }
        return null;
    }

    public static enum FenceShape {
        STRAIGHT,
        L_SHAPE,
        U_SHAPE,
        ZIG_ZAG;

    }

    public static enum TurnType {
        NONE,
        LEFT,
        RIGHT,
        STRAIGHT;

    }
}

