package com.provismet.cursedspawners;

import com.provismet.cursedspawners.networking.GameRulePayloadS2C;
import com.provismet.cursedspawners.registries.CSEntityTypes;
import com.provismet.cursedspawners.registries.CSItemGroups;
import com.provismet.cursedspawners.registries.CSItems;
import com.provismet.cursedspawners.registries.CSParticleTypes;
import com.provismet.cursedspawners.registries.CSSoundEvents;
import com.provismet.cursedspawners.utility.CSGamerules;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursedSpawnersMain implements ModInitializer {
	public static final String MODID = "cursed-spawners";
    public static final Logger LOGGER = LoggerFactory.getLogger("Cursed Spawners");

	public static class_2960 identifier (String path) {
		return class_2960.method_60655(MODID, path);
	}

	@Override
	public void onInitialize () {
		CSGamerules.init();
		CSItems.init();
		CSSoundEvents.init();
		CSEntityTypes.register();
		CSParticleTypes.register();
		CSItemGroups.register();

		PayloadTypeRegistry.playS2C().register(GameRulePayloadS2C.ID, GameRulePayloadS2C.CODEC);

		ServerPlayConnectionEvents.JOIN.register((networkHandler, packetSender, server) -> {
			packetSender.sendPacket(new GameRulePayloadS2C((float)server.method_30002().method_64395().method_20746(CSGamerules.BREAK_SPEED).get()));
		});
	}
}