package com.provismet.cursedspawners.entity;

import com.provismet.cursedspawners.CursedSpawnersMain;
import com.provismet.cursedspawners.registries.CSEntityTypes;
import com.provismet.cursedspawners.registries.CSSoundEvents;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_6012;
import net.minecraft.class_6024;
import net.minecraft.class_6088;
import net.minecraft.class_7094;
import net.minecraft.class_7923;
import net.minecraft.class_8942;

public class SpawnerMimicEntity extends class_1588 {
    private int spawnDelay = 20;
    private class_6012<class_1952> spawnPotentials = class_6012.method_34990();
    private class_1952 spawnEntry;
    private double mobEntryRotation;
    private double prevMobEntryRotation;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private class_1297 renderedEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public final class_7094 idleState = new class_7094();
    public final class_7094 attackState = new class_7094();
    public final class_7094 spawnState = new class_7094();

    private static final class_2940<Boolean> RUNNING_SPAWN_ANIMATION = class_2945.method_12791(SpawnerMimicEntity.class, class_2943.field_13323);
    private static final class_2940<String> RENDERED_ENTITY_TYPE = class_2945.method_12791(SpawnerMimicEntity.class, class_2943.field_13326);

    public SpawnerMimicEntity (class_1937 world) {
        this(CSEntityTypes.SPAWNER_MIMIC, world);
    }

    public SpawnerMimicEntity (class_1299<? extends SpawnerMimicEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 30;
    }

    public static class_5132.class_5133 getSpawnerMimicAttributes () {
        return class_1588.method_26918()
            .method_26868(class_5134.field_23716, 10)
            .method_26868(class_5134.field_23718, 0.8)
            .method_26868(class_5134.field_23724, 25)
            .method_26868(class_5134.field_23725, 5)
            .method_26868(class_5134.field_23719, 0.275)
            .method_26868(class_5134.field_23721, 2)
            .method_26868(class_5134.field_23722, 1);
    }

    @Override
    protected void method_5959 () {
        super.method_5959();
        this.field_6185.method_6277(0, new class_1399(this));
        this.field_6185.method_6277(1, new class_1400<>(this, class_1657.class, true));

        this.field_6201.method_6277(0, new MimicAppearGoal(this));
        this.field_6201.method_6277(1, new MimicAttackGoal(this, 1, false));
        this.field_6201.method_6277(2, new class_1394(this, 1));
        this.field_6201.method_6277(3, new class_1361(this, class_1657.class, 16));
        this.field_6201.method_6277(4, new class_1376(this));
    }

    @Override
    protected void method_5693 (class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RUNNING_SPAWN_ANIMATION, false);
        builder.method_56912(RENDERED_ENTITY_TYPE, "");
    }

    @Override
    public void method_31471 (class_2604 packet) {
        super.method_31471(packet);
        this.spawnState.method_41322(this.field_6012);
        this.setRunningSpawnAnimation(true);
    }

    @Override
    protected void method_5749 (class_11368 view) {
        super.method_5749(view);

        this.spawnDelay = view.method_71432("Delay", (short)20);
        view.method_71426("SpawnData", class_1952.field_34460).ifPresent(this::setSpawnEntry);
        view.method_71426("SpawnPotentials", class_1952.field_34461).ifPresentOrElse(
            potentials -> this.spawnPotentials = potentials,
            () -> this.spawnPotentials = class_6012.method_66214(this.spawnEntry != null ? this.spawnEntry : new class_1952())
        );
        this.minSpawnDelay = view.method_71432("MinSpawnDelay", (short)this.minSpawnDelay);
        this.maxSpawnDelay = view.method_71432("MaxSpawnDelay", (short)this.maxSpawnDelay);
        this.spawnCount = view.method_71432("SpawnCount", (short)this.spawnCount);
        this.maxNearbyEntities = view.method_71432("MaxNearbyEntities", (short)this.maxNearbyEntities);
        this.requiredPlayerRange = view.method_71432("RequiredPlayerRange", (short)this.requiredPlayerRange);
        this.spawnRange = view.method_71432("SpawnRange", (short)this.spawnRange);

        this.renderedEntity = null;
    }

    @Override
    protected void method_5652 (class_11372 view) {
        super.method_5652(view);
        view.method_71471("Delay", (short)this.spawnDelay);
        view.method_71471("MinSpawnDelay", (short)this.minSpawnDelay);
        view.method_71471("MaxSpawnDelay", (short)this.maxSpawnDelay);
        view.method_71471("SpawnCount", (short)this.spawnCount);
        view.method_71471("MaxNearbyEntities", (short)this.maxNearbyEntities);
        view.method_71471("RequiredPlayerRange", (short)this.requiredPlayerRange);
        view.method_71471("SpawnRange", (short)this.spawnRange);
        if (this.spawnEntry != null) {
            view.method_71468("SpawnData", class_1952.field_34460, this.spawnEntry);
        }

        view.method_71468("SpawnPotentials", class_1952.field_34461, this.spawnPotentials);
    }

    @Override
    public void method_5674 (class_2940<?> data) {
        super.method_5674(data);
    }

    @Override
    public void method_5773 () {
        this.prevMobEntryRotation = this.mobEntryRotation;
        this.mobEntryRotation = (this.mobEntryRotation + (double)(1000f / ((float)this.spawnDelay + 200f))) % 360.0;
        this.setupAnimations();

        if (!this.method_5987() && this.method_73183() instanceof class_3218 serverWorld) {
            if (this.spawnDelay < 0) this.updateSpawns();
            if (this.spawnDelay > 0) this.spawnDelay--;
            else this.spawn(serverWorld);
        }

        if (this.method_73183().method_8608() && this.getRenderedEntity() != null) {
            double x = this.method_23317() + this.field_5974.method_43058() - 0.5;
            double y = this.method_23318() + this.field_5974.method_43058();
            double z = this.method_23321() + this.field_5974.method_43058() - 0.5;
            this.method_73183().method_8406(class_2398.field_11251, x, y, z, 0.0, 0.0, 0.0);
            this.method_73183().method_8406(class_2398.field_11240, x, y, z, 0.0, 0.0, 0.0);
        }

        super.method_5773();
    }

    private void setupAnimations () {
        if (!this.method_6150()) this.idleState.method_41324(this.field_6012);
        else this.idleState.method_41325();

        if (this.isRunningSpawnAnimation()) this.spawnState.method_41324(this.field_6012);

        if (!this.method_6510()) this.attackState.method_41325();
    }

    @Override
    public boolean method_6121 (class_3218 world, class_1297 target) {
        this.method_73183().method_8421(this, class_6024.field_30029);
        return super.method_6121(world, target);
    }

    @Override
    public void method_5711 (byte status) {
        super.method_5711(status);
        if (status == class_6024.field_30029) {
            this.attackState.method_41322(this.field_6012);
        }
    }

    @Override
    public boolean method_30948 (@Nullable class_1297 entity) {
        return this.method_5805();
    }

    @Override
    public void method_5844 (class_2680 state, class_243 multiplier) {
        if (!state.method_27852(class_2246.field_10343)) {
            super.method_5844(state, multiplier);
        }
    }

    @Override
    protected void method_59928 () {
        this.method_56078(CSSoundEvents.ENTITY_MIMIC_ATTACK);
    }

    @Override
    protected class_3414 method_5994 () {
        return CSSoundEvents.ENTITY_MIMIC_AMBIENT;
    }

    @Override
    protected class_3414 method_6002 () {
        return CSSoundEvents.ENTITY_MIMIC_DEATH;
    }

    @Override
    protected class_3414 method_6011 (class_1282 source) {
        return CSSoundEvents.ENTITY_MIMIC_HURT;
    }

    @Override
    protected void method_5712 (class_2338 pos, class_2680 state) {
        this.method_56078(CSSoundEvents.ENTITY_MIMIC_STEP);
    }

    @Override
    protected class_1269 method_5992 (class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        if (held.method_7909() instanceof class_1826 spawnEgg) {
            class_1299<?> entityType = spawnEgg.method_8015(held);
            this.setEntityType(entityType);
            this.method_73183().method_33596(player, class_5712.field_28725, this.method_24515());
            held.method_7934(1);
            this.spawnDelay = 20;
            return class_1269.field_5812;
        }
        else {
            return super.method_5992(player, hand);
        }
    }

    @Override
    protected class_1269 method_29506 (class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        if (held.method_7909() instanceof class_1826) return class_1269.field_5811;
        return super.method_29506(player, hand);
    }

    protected void spawn (class_3218 serverWorld) {
        boolean spawnedSuccessfully = false;
        class_1952 mobSpawnerEntry = this.getSpawnEntry();

        for (int i = 0; i < this.spawnCount; i++) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(this::toString, CursedSpawnersMain.LOGGER)) {
                class_11368 readView = class_11352.method_71417(logging, serverWorld.method_30349(), mobSpawnerEntry.method_38093());
                Optional<class_1299<?>> optionalEntityType = class_1299.method_17684(readView);
                if (optionalEntityType.isEmpty()) {
                    this.updateSpawns();
                    return;
                }

                class_243 mobPos = readView.method_71426("Pos", class_243.field_38277).orElseGet(
                    () -> new class_243(
                        this.method_23317() + (field_5974.method_43058() - field_5974.method_43058()) * this.spawnRange + 0.5,
                        this.method_23318() + field_5974.method_43048(3) - 1,
                        this.method_23321() + (field_5974.method_43058() - field_5974.method_43058()) * this.spawnRange + 0.5
                    )
                );

                if (this.method_73183().method_18026(optionalEntityType.get().method_58629(mobPos.method_10216(), mobPos.method_10214(), mobPos.method_10215()))) {
                    class_2338 mobBlockPos = class_2338.method_49638(mobPos);
                    if (mobSpawnerEntry.method_38097().isPresent()) {
                        if (!optionalEntityType.get().method_5891().method_6136() && this.method_73183().method_8407() == class_1267.field_5801) {
                            continue;
                        }

                        class_1952.class_6542 customSpawnRules = mobSpawnerEntry.method_38097().get();
                        if (!customSpawnRules.method_56563(mobBlockPos, serverWorld)) {
                            continue;
                        }
                    } else if (!class_1317.method_20638(optionalEntityType.get(), serverWorld, class_3730.field_16469, mobBlockPos, this.method_59922())) {
                        continue;
                    }

                    class_1297 entity = class_1299.method_17842(readView, serverWorld, class_3730.field_16469, entityx -> {
                        entityx.method_5808(mobPos.method_10216(), mobPos.method_10214(), mobPos.method_10215(), entityx.method_36454(), entityx.method_36455());
                        return entityx;
                    });

                    if (entity == null) {
                        this.updateSpawns();
                        return;
                    }

                    int nearbyEntityCount = this.method_73183().method_18023(
                        class_5575.method_55374(entity.getClass()),
                        new class_238(this.method_23317(), this.method_23318(), this.method_23321(), this.method_23317() + 1, this.method_23318() + 1, this.method_23321() + 1).method_1014(this.spawnRange),
                        class_1301.field_6155
                    ).size();
                    if (nearbyEntityCount >= this.maxNearbyEntities) {
                        this.updateSpawns();
                        return;
                    }

                    entity.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), this.field_5974.method_43057() * 360.0F, 0.0F);
                    if (entity instanceof class_1308 mobEntity) {
                        if (mobSpawnerEntry.method_38097().isEmpty() && !mobEntity.method_5979(serverWorld, class_3730.field_16469) || !mobEntity.method_5957(serverWorld)) {
                            continue;
                        }

                        if (mobSpawnerEntry.method_38093().method_10546() == 1 && mobSpawnerEntry.method_38093().method_10545("id")) {
                            mobEntity.method_5943(serverWorld, serverWorld.method_8404(entity.method_24515()), class_3730.field_16469, null);
                        }

                        mobSpawnerEntry.method_59717().ifPresent(mobEntity::method_58634);
                    }

                    if (!serverWorld.method_30736(entity)) {
                        this.updateSpawns();
                        return;
                    }

                    serverWorld.method_20290(class_6088.field_31147, this.method_24515(), 0);
                    serverWorld.method_33596(entity, class_5712.field_28738, mobBlockPos);
                    if (entity instanceof class_1308 mobEntity) {
                        mobEntity.method_5990();
                    }

                    spawnedSuccessfully = true;
                }
            }
        }

        if (spawnedSuccessfully) {
            this.updateSpawns();
        }
    }

    private void updateSpawns () {
        if (this.maxSpawnDelay <= this.minSpawnDelay) this.spawnDelay = this.minSpawnDelay;
        else this.spawnDelay = this.minSpawnDelay + this.field_5974.method_43048(this.maxSpawnDelay - this.minSpawnDelay);

        this.spawnPotentials.method_34992(this.field_5974).ifPresent(this::setSpawnEntry);
    }

    public void setEntityType (class_1299<?> type) {
        String idString = class_7923.field_41177.method_10221(type).toString();
        this.getSpawnEntry().method_38093().method_10582("id", idString);
        this.field_6011.method_12778(RENDERED_ENTITY_TYPE, idString);
        this.renderedEntity = null;
    }

    @Nullable
    public class_1297 getRenderedEntity () {
        if (this.renderedEntity == null && this.getRenderedEntityType() != null)
            this.renderedEntity = class_1299.method_72386(this.getRenderedEntityType(), new class_2487(), this.method_73183(), class_3730.field_16469, Function.identity());

        return this.renderedEntity;
    }

    public double getMobRotation () {
        return this.mobEntryRotation;
    }

    public double getPrevMobRotation () {
        return this.prevMobEntryRotation;
    }

    protected void setSpawnEntry (@Nullable class_1952 spawnEntry) {
        this.spawnEntry = spawnEntry;
        if (spawnEntry != null) this.field_6011.method_12778(RENDERED_ENTITY_TYPE, spawnEntry.comp_64().method_68564("id", ""));
    }

    private class_1952 getSpawnEntry () {
        if (this.spawnEntry == null) {
            this.setSpawnEntry(this.spawnPotentials.method_34992(this.field_5974).orElseGet(class_1952::new));
        }
        return this.spawnEntry;
    }

    public void setRunningSpawnAnimation (boolean value) {
        this.method_5841().method_12778(RUNNING_SPAWN_ANIMATION, value);
    }

    public boolean isRunningSpawnAnimation () {
        return this.method_5841().method_12789(RUNNING_SPAWN_ANIMATION);
    }

    @Nullable
    public class_1299<?> getRenderedEntityType () {
        class_2960 id = class_2960.method_12829(this.field_6011.method_12789(RENDERED_ENTITY_TYPE));
        if (id == null) return null;

        return class_7923.field_41177.method_17966(id).orElse(null);
    }

    protected static class MimicAttackGoal extends class_1366 {
        public MimicAttackGoal (SpawnerMimicEntity mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }
    }

    protected static class MimicAppearGoal extends class_1352 {
        private static final int INITIAL_AGE = -100;
        private final SpawnerMimicEntity self;
        private int startingAge = INITIAL_AGE;

        public MimicAppearGoal (SpawnerMimicEntity mob) {
            this.self = mob;
            this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406, class_4134.field_18407, class_4134.field_18408));
        }

        @Override
        public boolean method_6264 () {
            return this.startingAge == INITIAL_AGE || this.self.isRunningSpawnAnimation();
        }

        @Override
        public void method_6269 () {
            this.startingAge = this.self.field_6012;
        }

        @Override
        public void method_6270 () {
            this.self.setRunningSpawnAnimation(false);
        }

        @Override
        public boolean method_6266 () {
            return this.self.field_6012 <= this.startingAge + 40;
        }
    }
}
