package com.provismet.cursedspawners.entity.renderers;

import com.provismet.cursedspawners.CursedSpawnersMain;
import com.provismet.cursedspawners.entity.SpawnerMimicEntity;
import com.provismet.cursedspawners.entity.models.SpawnerMimicModel;
import com.provismet.cursedspawners.entity.renderers.states.SpawnerMimicRenderState;
import com.provismet.cursedspawners.registries.client.CSModelLayers;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.minecraft.class_927;

public class SpawnerMimicEntityRenderer extends class_927<SpawnerMimicEntity, SpawnerMimicRenderState, SpawnerMimicModel> {
    private static final class_2960 TEXTURE = CursedSpawnersMain.identifier("textures/entity/spawner_mimic.png");

    private final class_898 dispatcher;

    public SpawnerMimicEntityRenderer (class_5617.class_5618 context) {
        super(context, new SpawnerMimicModel(context.method_32167(CSModelLayers.SPAWNER_MIMIC)), 0.6f);
        this.field_4676 = context.method_32166();
    }

    @Override
    public SpawnerMimicRenderState method_55269 () {
        return new SpawnerMimicRenderState();
    }

    @Override
    public void updateRenderState (SpawnerMimicEntity mimic, SpawnerMimicRenderState state, float tickDelta) {
        super.method_62355(mimic, state, tickDelta);
        state.attackState.method_61401(mimic.attackState);
        state.idleState.method_61401(mimic.idleState);
        state.spawnState.method_61401(mimic.spawnState);
        state.mobRotation = class_3532.method_16436(tickDelta, mimic.getPrevMobRotation(), mimic.getMobRotation());
        if (mimic.getRenderedEntity() != null) state.renderedEntityState = this.field_4676.method_72977(mimic.getRenderedEntity(), tickDelta);
        else state.renderedEntityState = null;
    }

    @Override
    public void render (SpawnerMimicRenderState state, class_4587 matrixStack, class_11659 orderedRenderCommandQueue, class_12075 cameraRenderState) {
        super.method_4054(state, matrixStack, orderedRenderCommandQueue, cameraRenderState);

        if (state.renderedEntityState != null) { // Yoinked from MobSpawnerBlockEntityRenderer
            matrixStack.method_22903();
            matrixStack.method_46416(0f, 0.25f, 0f);
            float f = 0.53125f;
            float g = Math.max(state.renderedEntityState.field_53329, state.renderedEntityState.field_53330);
            if ((double)g > 1.0) {
                f /= g;
            }

            matrixStack.method_46416(0f, 0.4f, 0f);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees((float)state.mobRotation * 10f));
            matrixStack.method_46416(0f, -0.2f, 0f);
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-30f));
            matrixStack.method_22905(f, f, f);
            this.field_4676.method_72976(state.renderedEntityState, cameraRenderState, 0, 0, 0, matrixStack, orderedRenderCommandQueue);
            matrixStack.method_22909();
        }
    }

    @Override
    public class_2960 getTexture (SpawnerMimicRenderState entity) {
        return TEXTURE;
    }
}
