package com.provismet.cursedspawners.mixin;

import com.mojang.serialization.Codec;
import com.provismet.cursedspawners.imixin.IMixinMobSpawnerBlockEntity;
import com.provismet.cursedspawners.imixin.IMixinMobSpawnerLogic;
import com.provismet.cursedspawners.utility.CSGamerules;
import com.provismet.cursedspawners.utility.SpawnerBreakEffects;
import com.provismet.cursedspawners.utility.SpawnerEffects;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8934;
import net.minecraft.class_9297;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

@Mixin(class_2636.class)
public abstract class MobSpawnerBlockEntityMixin extends class_2586 implements IMixinMobSpawnerBlockEntity, class_8934 {
    @Shadow @Final private class_1917 logic;

    @Unique private static final String REFORGE_ACTIONS = "ReforgeActions";
    @Unique private static final String BREAK_ACTION = "BreakAction";
    @Unique private static final String RANDOMISE = "ShouldGenerateEffects";

    @Unique private static final String MIMIC_CHANCE = "MimicChance";
    @Unique private static final double PASSTHROUGH_MIMIC_CHANCE = -1;

    public MobSpawnerBlockEntityMixin (class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Unique private final class_2371<class_1799> inventory = class_2371.method_10213(27, class_1799.field_8037);

    @Unique private long lootTableSeed = 0;
    @Unique private class_5321<class_52> lootTable = null;
    @Unique private double mimicChance = PASSTHROUGH_MIMIC_CHANCE;
    @Unique private List<String> reforgeActions = new ArrayList<>();
    @Unique private String breakAction = SpawnerBreakEffects.NORMAL_BREAK;

    @Unique private boolean shouldRandomiseEffects = true;

    @Inject(method="readData", at=@At("TAIL"))
    private void readExtendedNbt (class_11368 view, CallbackInfo ci) {
        this.mimicChance = view.method_71422(MIMIC_CHANCE, PASSTHROUGH_MIMIC_CHANCE);
        this.shouldRandomiseEffects = view.method_71433(RANDOMISE, true);
        this.breakAction = view.method_71428(BREAK_ACTION, SpawnerBreakEffects.NORMAL_BREAK);

        view.method_71426(REFORGE_ACTIONS, Codec.STRING.listOf()).ifPresentOrElse(
            actions -> this.reforgeActions = new ArrayList<>(actions),
            () -> this.reforgeActions = new ArrayList<>()
        );

        this.method_54871(view);
    }

    @Inject(method="writeData", at=@At("TAIL"))
    private void writeExtendedNbt (class_11372 view, CallbackInfo ci) {
        view.method_71463(MIMIC_CHANCE, this.mimicChance);
        view.method_71468(REFORGE_ACTIONS, Codec.STRING.listOf(), this.reforgeActions);
        view.method_71469(BREAK_ACTION, this.breakAction);
        view.method_71472(RANDOMISE, this.shouldRandomiseEffects);
        this.method_54872(view);
    }

    @Override
    public double cursed_spawners$getMimicChance () {
        return this.mimicChance;
    }

    @Override
    public boolean cursed_spawners$useWorldMimicChance () {
        return this.mimicChance == PASSTHROUGH_MIMIC_CHANCE;
    }

    @Inject(method="serverTick", at=@At("HEAD"))
    private static void tick (class_1937 world, class_2338 pos, class_2680 state, class_2636 blockEntity, CallbackInfo info) {
        MobSpawnerBlockEntityMixin self = (MobSpawnerBlockEntityMixin)(Object)blockEntity;
        if (self != null && self.shouldRandomiseEffects && self.method_11002() && world instanceof class_3218 serverWorld && serverWorld.method_64395().method_20746(CSGamerules.SPAWNER_ACTION_CHANCE).get() > 0) {
            self.generateEffects(serverWorld);
            self.method_5431();
        }
    }

    @Unique
    private void generateEffects (class_3218 world) {
        this.shouldRandomiseEffects = false;
        class_5819 random = world.method_8409();

        int dangerLevel = 0;
        double chanceToAddAction = world.method_64395().method_20746(CSGamerules.SPAWNER_ACTION_CHANCE).get();
        while (dangerLevel < 7) {
            if (random.method_43058() < chanceToAddAction) ++dangerLevel;
            else break;
        }

        for (int i = 0; i < dangerLevel; ++i) {
            IMixinMobSpawnerLogic mixinLogic = (IMixinMobSpawnerLogic)this.logic;

            List<SpawnerEffects> possibleEffects = new ArrayList<>();
            possibleEffects.add(SpawnerEffects.REFORGE);
            if (Objects.equals(this.breakAction, SpawnerBreakEffects.NORMAL_BREAK)) possibleEffects.add(SpawnerEffects.BREAK);
            if (!mixinLogic.cursed_spawners$getCanKnockback()) possibleEffects.add(SpawnerEffects.KNOCKBACK);
            if (!mixinLogic.cursed_spawners$getCanHeal()) possibleEffects.add(SpawnerEffects.HEAL);
            if (!mixinLogic.cursed_spawners$getCanBoost()) possibleEffects.add(SpawnerEffects.BOOST);

            SpawnerEffects chosen = possibleEffects.get(random.method_43048(possibleEffects.size()));
            if (chosen == SpawnerEffects.BREAK) this.breakAction = SpawnerBreakEffects.getRandomEffectKey(random);
            else if (chosen == SpawnerEffects.REFORGE) this.reforgeActions.add(SpawnerBreakEffects.getRandomEffectKey(random));
            else if (chosen == SpawnerEffects.KNOCKBACK) {
                mixinLogic.cursed_spawners$setCanKnockback(true);
                mixinLogic.cursed_spawners$setKnockbackParams(
                    random.method_39332(100, 160),
                    random.method_43385(1.5, 0.5),
                    random.method_43385(5, 0.75)
                );
            }
            else if (chosen == SpawnerEffects.HEAL) {
                mixinLogic.cursed_spawners$setCanHeal(true);
                mixinLogic.cursed_spawners$setHealParams(
                    random.method_39332(80, 160),
                    2f,
                    random.method_62816(5, 1)
                );
            }
            else if (chosen == SpawnerEffects.BOOST) {
                mixinLogic.cursed_spawners$setCanBoost(true);
                mixinLogic.cursed_spawners$setBoostParams(
                    random.method_39332(120, 200),
                    random.method_62816(8, 4)
                );
            }
        }

        if (dangerLevel > 0 && this.lootTable == null) {
            if (dangerLevel < 3) this.lootTable = class_39.field_803;
            else if (dangerLevel < 6) this.lootTable = class_39.field_356;
            else this.lootTable = class_39.field_484;
        }
    }

    @Override
    public boolean cursed_spawners$attemptBreak () {
        if (!(this.field_11863 instanceof class_3218 serverWorld)) return true;
        if (this.reforgeActions.isEmpty()) {
            SpawnerBreakEffects.getEffect(this.breakAction).accept((class_2636)(Object)this, serverWorld);
            return true;
        }

        String nextAction = this.reforgeActions.removeFirst();
        class_243 centrePos = this.method_11016().method_46558();
        serverWorld.method_65096(class_2398.field_11203, centrePos.method_10216(), centrePos.method_10214(), centrePos.method_10215(), 20, 0.5, 0.5, 0.5, 0);
        SpawnerBreakEffects.getEffect(nextAction).accept((class_2636)(Object)this, serverWorld);
        return false;
    }

    @Override
    public void cursed_spawners$setShouldGenerateEffects (boolean value) {
        this.shouldRandomiseEffects = value;
    }

    @Nullable
    @Override
    public class_5321<class_52> method_54869 () {
        return this.lootTable;
    }

    @Override
    public void method_11285 (@Nullable class_5321<class_52> lootTable) {
        this.lootTable = lootTable;
    }

    @Override
    public long method_54870 () {
        return this.lootTableSeed;
    }

    @Override
    public void method_54866 (long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }

    @Override
    public int method_5439 () {
        this.method_54873(null);
        return this.inventory.size();
    }

    @Override
    public boolean method_5442 () {
        this.method_54873(null);
        return this.inventory.isEmpty();
    }

    @Override
    public class_1799 method_5438 (int slot) {
        this.method_54873(null);
        if (this.inventory.size() <= slot) return class_1799.field_8037;
        return this.inventory.get(slot);
    }

    @Override
    public class_1799 method_5434 (int slot, int amount) {
        this.method_54873(null);
        class_1799 itemStack = class_1262.method_5430(this.inventory, slot, amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    @Override
    public class_1799 method_5441 (int slot) {
        this.method_54873(null);
        return class_1262.method_5428(this.inventory, slot);
    }

    @Override
    public void method_5447 (int slot, class_1799 stack) {
        this.method_54873(null);
        this.inventory.set(slot, stack);
        stack.method_58408(this.method_58350(stack));
        this.method_5431();
    }

    @Override
    public boolean method_5443 (class_1657 player) {
        return false;
    }

    @Override
    public void method_5448 () {
        this.inventory.clear();
    }

    @Override
    protected void method_57568 (class_9473 components) {
        super.method_57568(components);
        class_9297 containerLootComponent = components.method_58694(class_9334.field_49626);
        if (containerLootComponent != null) {
            this.lootTable = containerLootComponent.comp_2414();
            this.lootTableSeed = containerLootComponent.comp_2415();
        }
    }

    @Override
    protected void method_57567 (class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        if (this.lootTable != null) {
            componentMapBuilder.method_57840(class_9334.field_49626, new class_9297(this.lootTable, this.lootTableSeed));
        }
    }
}
