package com.provismet.cursedspawners.mixin;

import com.provismet.cursedspawners.imixin.IMixinMobSpawnerLogic;
import com.provismet.cursedspawners.particle.effect.AOEChargingParticleEffect;
import com.provismet.cursedspawners.registries.CSParticleTypes;
import com.provismet.cursedspawners.registries.CSSoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1588;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5134;

@Mixin(class_1917.class)
public abstract class MobSpawnerLogicMixin implements IMixinMobSpawnerLogic {
    @Unique private static final String CAN_KNOCKBACK = "CanKnockback";
    @Unique private static final String MAX_KNOCKBACK_TIMER = "KnockbackInterval";
    @Unique private static final String KNOCKBACK_STRENGTH = "KnockbackStrength";
    @Unique private static final String KNOCKBACK_RADIUS = "KnockbackRadius";

    @Unique private static final String CAN_HEAL = "CanHeal";
    @Unique private static final String MAX_HEAL_TIMER = "HealInterval";
    @Unique private static final String HEAL_AMOUNT = "HealAmount";
    @Unique private static final String HEAL_RADIUS = "HealRadius";

    @Unique private static final String CAN_BOOST = "CanBoost";
    @Unique private static final String MAX_BOOST_TIMER = "BoostInterval";
    @Unique private static final String BOOST_RADIUS = "BoostRadius";

    @Unique private boolean canKnockback = false;
    @Unique private int knockbackTimer = 200;
    @Unique private int maxKnockbackTimer = 200;
    @Unique private double knockbackStrength = 0.2;
    @Unique private double knockbackRadius = 4;

    @Unique private boolean canHeal = false;
    @Unique private int healTimer = 200;
    @Unique private int maxHealTimer = 200;
    @Unique private float healAmount = 0f;
    @Unique private double healRadius = 0;

    @Unique private boolean canBoost = false;
    @Unique private int boostTimer = 200;
    @Unique private int maxBoostTimer = 200;
    @Unique private double boostRadius = 0f;

    @Inject(method="readData", at=@At("TAIL"))
    private void readExtendedNbt (class_1937 world, class_2338 pos, class_11368 view, CallbackInfo ci) {
        this.canKnockback = view.method_71433(CAN_KNOCKBACK, false);
        this.maxKnockbackTimer = view.method_71424(MAX_KNOCKBACK_TIMER, 200);
        this.knockbackStrength = view.method_71422(KNOCKBACK_STRENGTH, 0.2);
        this.knockbackRadius = view.method_71422(KNOCKBACK_RADIUS, 4);
        this.canHeal = view.method_71433(CAN_HEAL, false);
        this.maxHealTimer = view.method_71424(MAX_HEAL_TIMER, 200);
        this.healAmount = view.method_71423(HEAL_AMOUNT, 0f);
        this.healRadius = view.method_71422(HEAL_RADIUS, 0);
        this.canBoost = view.method_71433(CAN_BOOST, false);
        this.maxBoostTimer = view.method_71424(MAX_BOOST_TIMER, 200);
        this.boostRadius = view.method_71422(BOOST_RADIUS, 0);

        this.knockbackTimer = Math.min(this.knockbackTimer, this.maxKnockbackTimer);
        this.healTimer = Math.min(this.healTimer, this.maxHealTimer);
        this.boostTimer = Math.min(this.boostTimer, this.maxBoostTimer);
    }

    @Inject(method="writeData", at=@At("TAIL"))
    private void writeExtendedNbt (class_11372 view, CallbackInfo ci) {
        view.method_71472(CAN_KNOCKBACK, this.canKnockback);
        view.method_71465(MAX_KNOCKBACK_TIMER, this.maxKnockbackTimer);
        view.method_71463(KNOCKBACK_STRENGTH, this.knockbackStrength);
        view.method_71463(KNOCKBACK_RADIUS, this.knockbackRadius);

        view.method_71472(CAN_HEAL, this.canHeal);
        view.method_71465(MAX_HEAL_TIMER, this.maxHealTimer);
        view.method_71464(HEAL_AMOUNT, this.healAmount);
        view.method_71463(HEAL_RADIUS, this.healRadius);

        view.method_71472(CAN_BOOST, this.canBoost);
        view.method_71465(MAX_BOOST_TIMER, this.maxBoostTimer);
        view.method_71463(BOOST_RADIUS, this.boostRadius);
    }

    @Inject(method="serverTick", at=@At(
        value="INVOKE",
        target="Lnet/minecraft/block/spawner/MobSpawnerLogic;isPlayerInRange(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z",
        shift=At.Shift.AFTER)
    )
    private void performActions (class_3218 world, class_2338 pos, CallbackInfo ci) {
        class_243 centrePos = pos.method_46558();

        if (this.canKnockback) {
            --this.knockbackTimer;

            if (this.knockbackTimer == this.maxKnockbackTimer / 2) {
                world.method_65096(new AOEChargingParticleEffect(this.knockbackTimer, class_243.method_24457(0xE2E2E2).method_46409()), centrePos.method_10216(), pos.method_10264() + 0.025, centrePos.method_10215(), 1, 0, 0, 0, 0);
            }
            else if (this.knockbackTimer <= 0) {
                this.knockbackTimer = this.maxKnockbackTimer;
                world.method_65096(class_2398.field_49139, centrePos.method_10216(), centrePos.method_10214(), centrePos.method_10215(), 1, 0, 0, 0, 0);
                List<class_3222> players = world.method_18766(player -> player.method_73189().method_55230(centrePos, this.knockbackRadius, this.knockbackRadius) && !player.method_68878() && !player.method_7325());
                for (class_3222 player : players) {
                    double strength = this.knockbackStrength * (1 - player.method_45325(class_5134.field_23718));
                    if (strength > 0) {
                        class_243 velocity = new class_243(player.method_23317() - centrePos.method_10216(), player.method_23318() >= pos.method_10264() ? 0.5 : -0.5, player.method_23321() - centrePos.method_10215()).method_1029().method_1021(strength);
                        player.method_60491(velocity);
                        player.field_6037 = true;
                    }
                }
                world.method_8396(null, pos, CSSoundEvents.BLOCK_SPAWNER_KNOCKBACK, class_3419.field_15245, 1, 1);
            }
        }

        if (this.canHeal) {
            --this.healTimer;

            if (this.healTimer == this.maxHealTimer / 2) {
                world.method_65096(new AOEChargingParticleEffect(this.healTimer, class_243.method_24457(0x47BC78).method_46409()), centrePos.method_10216(), pos.method_10264() + 0.025, centrePos.method_10215(), 1, 0, 0, 0, 0);
            }
            else if (this.healTimer <= 0) {
                this.healTimer = this.maxHealTimer;
                world.method_65096(CSParticleTypes.HEAL, centrePos.method_10216(), centrePos.method_10214() + 0.5, centrePos.method_10215(), 1, 0, 0, 0, 0);
                List<class_1588> mobs = world.method_8390(class_1588.class, class_238.method_30048(centrePos, this.healRadius, 3, this.healRadius), mob -> true);
                for (class_1588 hostile : mobs) {
                    hostile.method_6025(this.healAmount);
                    world.method_65096(class_2398.field_11211, hostile.method_23317(), hostile.method_23320(), hostile.method_23321(), 8, 0.35, 0.35, 0.35, 0);
                }
                world.method_8396(null, pos, CSSoundEvents.BLOCK_SPAWNER_HEAL, class_3419.field_15245, 1, 1);
            }
        }

        if (this.canBoost) {
            --this.boostTimer;

            if (this.boostTimer == this.maxBoostTimer / 2) {
                world.method_65096(new AOEChargingParticleEffect(this.boostTimer, class_243.method_24457(0xFF8459).method_46409()), centrePos.method_10216(), pos.method_10264() + 0.025, centrePos.method_10215(), 1, 0, 0, 0, 0);
            }
            else if (this.boostTimer <= 0) {
                this.boostTimer = this.maxBoostTimer;
                world.method_65096(CSParticleTypes.BOOST, centrePos.method_10216(), centrePos.method_10214() + 0.5, centrePos.method_10215(), 1, 0, 0, 0, 0);
                List<class_1588> mobs = world.method_8390(class_1588.class, class_238.method_30048(centrePos, this.boostRadius, 3, this.boostRadius), mob -> true);
                for (class_1588 hostile : mobs) {
                    hostile.method_6092(new class_1293(class_1294.field_5904, 30, 1));
                    world.method_65096(class_2398.field_11211, hostile.method_23317(), hostile.method_23320(), hostile.method_23321(), 8, 0.35, 0.35, 0.35, 0);
                }
                world.method_8396(null, pos, CSSoundEvents.BLOCK_SPAWNER_BOOST, class_3419.field_15245, 1, 1);
            }
        }
    }

    @Override
    public boolean cursed_spawners$getCanKnockback () {
        return this.canKnockback;
    }

    @Override
    public void cursed_spawners$setCanKnockback (boolean value) {
        this.canKnockback = value;
    }

    @Override
    public void cursed_spawners$setKnockbackParams (int interval, double strength, double radius) {
        this.maxKnockbackTimer = interval;
        this.knockbackTimer = Math.min(this.knockbackTimer, this.maxKnockbackTimer);
        this.knockbackStrength = strength;
        this.knockbackRadius = radius;
    }

    @Override
    public boolean cursed_spawners$getCanHeal () {
        return this.canHeal;
    }

    @Override
    public void cursed_spawners$setCanHeal (boolean value) {
        this.canHeal = value;
    }

    @Override
    public void cursed_spawners$setHealParams (int interval, float amount, double radius) {
        this.maxHealTimer = interval;
        this.healTimer = Math.min(this.healTimer, this.maxHealTimer);
        this.healAmount = amount;
        this.healRadius = radius;
    }

    @Override
    public boolean cursed_spawners$getCanBoost () {
        return this.canBoost;
    }

    @Override
    public void cursed_spawners$setCanBoost (boolean value) {
        this.canBoost = value;
    }

    @Override
    public void cursed_spawners$setBoostParams (int interval, double radius) {
        this.maxBoostTimer = interval;
        this.boostTimer = Math.min(this.boostTimer, this.maxBoostTimer);
        this.boostRadius = radius;
    }
}
