package com.provismet.cursedspawners.mixin;

import com.provismet.cursedspawners.imixin.IMixinMobSpawnerBlockEntity;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3225.class)
public abstract class ServerPlayerInteractionManagerMixin {
    @Shadow protected class_3218 world;

    @Shadow @Final protected class_3222 player;

    @Inject(method="tryBreakBlock", at=@At(
        value="INVOKE",
        target="Lnet/minecraft/block/Block;onBreak(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/block/BlockState;",
        shift = At.Shift.BEFORE),
        cancellable=true
    )
    private void falseBreak (class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (!this.player.method_68878() && !this.player.method_7325() && this.world.method_8321(pos) instanceof IMixinMobSpawnerBlockEntity spawnerBlockEntity) {
            if (!spawnerBlockEntity.cursed_spawners$attemptBreak()) cir.setReturnValue(false);
        }
    }
}
