package com.provismet.cursedspawners.mixin;

import com.provismet.cursedspawners.CursedSpawnersMain;
import com.provismet.cursedspawners.entity.SpawnerMimicEntity;
import com.provismet.cursedspawners.imixin.IMixinMobSpawnerBlockEntity;
import com.provismet.cursedspawners.networking.ClientPacketReceiver;
import com.provismet.cursedspawners.utility.CSGamerules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.UUID;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2496;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_8942;

@Mixin(class_2496.class)
public abstract class SpawnerBlockMixin extends class_2237 {
    protected SpawnerBlockMixin (class_2251 settings) {
        super(settings);
    }

    @Override
    public class_2680 method_9576 (class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        state = super.method_9576(world, pos, state, player);
        if (player.method_68878() || !(world instanceof class_3218 serverWorld)) return state;

        double worldMimicChance = serverWorld.method_64395().method_20746(CSGamerules.MIMIC_CHANCE).get();
        if (worldMimicChance >= 0 && world.method_8321(pos) instanceof class_2636 blockEntity) {
            double blockMimicChance;
            if (((IMixinMobSpawnerBlockEntity)blockEntity).cursed_spawners$useWorldMimicChance()) blockMimicChance = worldMimicChance;
            else blockMimicChance = ((IMixinMobSpawnerBlockEntity)blockEntity).cursed_spawners$getMimicChance();

            if (world.method_8409().method_43058() <= blockMimicChance) {
                class_2487 nbt = blockEntity.method_38242(world.method_30349()).method_10553();
                SpawnerMimicEntity mimic = new SpawnerMimicEntity(world);
                UUID uuid = mimic.method_5667();

                if (nbt.method_10568("MinSpawnDelay").isPresent()) nbt.method_10575("MinSpawnDelay", (short)(nbt.method_10568("MinSpawnDelay").get() / 1.5));
                if (nbt.method_10568("MaxSpawnDelay").isPresent()) nbt.method_10575("MaxSpawnDelay", (short)(nbt.method_10568("MaxSpawnDelay").get() / 1.5));
                if (nbt.method_10545("Delay")) nbt.method_10575("Delay", (short)20);

                try (class_8942.class_11340 logging = new class_8942.class_11340(this::toString, CursedSpawnersMain.LOGGER)) {
                    class_11368 view = class_11352.method_71417(logging, serverWorld.method_30349(), nbt);
                    mimic.method_5651(view);
                    mimic.method_5826(uuid);
                    mimic.method_5725(pos, 0, 0);
                    mimic.method_6015(player);
                    world.method_8649(mimic);
                }
            }
            else {
                class_1264.method_66221(state, world, pos);
            }
        }
        return state;
    }

    @Override
    protected float method_9594 (class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        float scale = super.method_9594(state, player, world, pos);

        if (player.method_73183().method_8608()) scale *= ClientPacketReceiver.SPAWNER_BREAK_MODIFIER;
        else if (player.method_73183() instanceof class_3218 serverWorld) scale *= (float)serverWorld.method_64395().method_20746(CSGamerules.BREAK_SPEED).get();

        return scale;
    }

    @Inject(method="onStacksDropped", at=@At("HEAD"), cancellable=true)
    private void preventExp (class_2680 state, class_3218 world, class_2338 pos, class_1799 tool, boolean dropExperience, CallbackInfo info) {
        if (!world.method_8390(SpawnerMimicEntity.class, class_238.method_30048(pos.method_46558(), 0.1, 0.1, 0.1), entity -> true).isEmpty())
            info.cancel();
    }
}
