package com.provismet.cursedspawners.particle.type;

import com.provismet.cursedspawners.particle.effect.AOEChargingParticleEffect;
import com.provismet.lilylib.particle.FlatParticle;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;

public class AOEChargingParticle extends FlatParticle {
    private float prevScale;
    private final float maxScale;

    protected AOEChargingParticle (class_638 clientWorld, double x, double y, double z, class_4002 spriteProvider, AOEChargingParticleEffect effect) {
        super(clientWorld, x, y, z, spriteProvider);
        this.field_17867 = 3f;
        this.maxScale = this.field_17867;
        this.prevScale = this.field_17867;
        this.field_3847 = effect.maxAge();
        this.field_62636 = 0;
        this.field_62633 = effect.colour().x();
        this.field_62634 = effect.colour().y();
        this.field_62635 = effect.colour().z();
    }

    @Override
    public void method_3070 () {
        super.method_3070();
        this.prevScale = this.field_17867;
        this.field_17867 = this.maxScale * (1 - (float)this.field_3866 / (float)this.field_3847);

        if (this.field_62636 < 1) this.field_62636 += 0.1f;
        if (this.field_62636 > 1) this.field_62636 = 1f;
    }

    @Override
    public float method_18132 (float tickDelta) {
        return class_3532.method_16439(tickDelta, this.prevScale, this.field_17867);
    }

    public static class Factory implements class_707<AOEChargingParticleEffect> {
        private final class_4002 spriteProvider;

        public Factory (class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Nullable
        @Override
        public class_703 createParticle (AOEChargingParticleEffect parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_5819 random) {
            return new AOEChargingParticle(world, x, y, z, this.spriteProvider, parameters);
        }
    }
}
