/*
 * Decompiled with CFR 0.152.
 */
package com.patapoke.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public final class PatAPokeConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "patapoke.json";
    private static Path configPath;
    public static final double DEFAULT_ANIMATION_LENGTH_SECONDS = 1.15;
    public static final int DEFAULT_FRIENDSHIP_GAIN = 10;
    public static final int DEFAULT_COOLDOWN_SECONDS = 300;
    public double animationLengthSeconds = 1.15;
    public int friendshipGain = 10;
    public int cooldownSeconds = 300;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PatAPokeConfig load(Logger logger) {
        Path path;
        configPath = path = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        PatAPokeConfig defaults = new PatAPokeConfig();
        if (!Files.exists(path, new LinkOption[0])) return defaults.persist(path, logger);
        try (BufferedReader reader = Files.newBufferedReader(path);){
            PatAPokeConfig loaded = (PatAPokeConfig)GSON.fromJson((Reader)reader, PatAPokeConfig.class);
            if (loaded == null) return defaults.persist(path, logger);
            PatAPokeConfig patAPokeConfig = loaded.normalized(path, logger);
            return patAPokeConfig;
        }
        catch (IOException e) {
            logger.warn("Failed to read {}: {}", (Object)FILE_NAME, (Object)e.getMessage());
        }
        return defaults.persist(path, logger);
    }

    private PatAPokeConfig normalized(Path path, Logger logger) {
        boolean updated = false;
        if (this.animationLengthSeconds <= 0.0) {
            this.animationLengthSeconds = 1.15;
            updated = true;
        }
        if (this.friendshipGain < 0) {
            this.friendshipGain = 10;
            updated = true;
        }
        if (this.cooldownSeconds < 0) {
            this.cooldownSeconds = 300;
            updated = true;
        }
        if (updated) {
            this.persist(path, logger);
        }
        return this;
    }

    private PatAPokeConfig persist(Path path, Logger logger) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to save {}: {}", (Object)FILE_NAME, (Object)e.getMessage());
        }
        return this;
    }

    public float animationLengthSeconds() {
        return (float)Math.max(this.animationLengthSeconds, 0.25);
    }

    public int friendshipGain() {
        return Math.max(this.friendshipGain, 0);
    }

    public long cooldownTicks() {
        return (long)Math.max(this.cooldownSeconds, 0) * 20L;
    }

    public void save(Logger logger) {
        if (configPath == null) {
            logger.warn("Config path not initialized; skipping save.");
            return;
        }
        this.persist(configPath, logger);
    }
}

