/*
 * Decompiled with CFR 0.152.
 */
package com.patapoke.petting;

import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.animation.PlayPosableAnimationPacket;
import com.patapoke.PatAPoke;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class PettingHandler {
    private static final double APPROACH_DISTANCE_SQ = 4.0;
    private static final int MAX_APPROACH_ATTEMPTS = 40;
    private static final double APPROACH_SPEED = 1.15;
    private static final int HEART_PARTICLES = 8;
    private static final int MID_HEART_PARTICLES = 4;
    private static final double HEAD_LOOK_OFFSET = 0.15;
    private static final double[] ANIMATION_PHASES = new double[]{0.22, 0.5, 0.78, 1.0};
    private static final Map<UUID, Long> FRIENDSHIP_COOLDOWNS = new HashMap<UUID, Long>();

    private PettingHandler() {
    }

    public static void startPetting(class_3222 player, UUID pokemonId) {
        Objects.requireNonNull(player, "player");
        class_3218 level = player.method_51469();
        class_1297 entity = level.method_14190(pokemonId);
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        if (!pokemonEntity.method_5805() || pokemonEntity.isBattleClone() || pokemonEntity.getPokemon().isFainted()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.patapoke.petting.unavailable"), true);
            return;
        }
        if (!pokemonEntity.getPokemon().belongsTo((class_1657)player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.patapoke.petting.not_owner"), true);
            return;
        }
        if (pokemonEntity.isBusy() || pokemonEntity.isBattling()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.patapoke.petting.busy"), true);
            return;
        }
        Object lock = new Object();
        pokemonEntity.getBusyLocks().add(lock);
        PettingHandler.guidePokemonTowardPlayer(pokemonEntity, player);
        PettingHandler.waitForArrival(player, pokemonEntity, lock, player.method_5715(), 0);
    }

    private static void waitForArrival(class_3222 player, PokemonEntity pokemon, Object lock, boolean wasSneaking, int attempts) {
        if (!PettingHandler.isValid(player, pokemon)) {
            PettingHandler.releaseLock(pokemon, lock);
            return;
        }
        double distance = pokemon.method_5858((class_1297)player);
        if (distance > 4.0 && attempts < 40) {
            PettingHandler.guidePokemonTowardPlayer(pokemon, player);
            SchedulingFunctionsKt.afterOnServer((float)0.1f, () -> {
                PettingHandler.waitForArrival(player, pokemon, lock, wasSneaking, attempts + 1);
                return Unit.INSTANCE;
            });
            return;
        }
        if (distance > 4.0) {
            PettingHandler.releaseLock(pokemon, lock);
            return;
        }
        PettingHandler.beginPettingAnimation(player, pokemon, lock, wasSneaking);
    }

    private static void beginPettingAnimation(class_3222 player, PokemonEntity pokemon, Object lock, boolean wasSneaking) {
        boolean shouldCrouch;
        boolean bl = shouldCrouch = pokemon.method_17682() < 1.2f;
        if (shouldCrouch && !wasSneaking) {
            player.method_5660(true);
        }
        PettingHandler.facePokemon(player, pokemon, 0.15);
        pokemon.getNavigation().method_6340();
        pokemon.method_5988().method_6226((class_1297)player, 45.0f, 45.0f);
        PettingHandler.playPetAnimation(pokemon);
        pokemon.cry();
        player.method_23667(class_1268.field_5808, true);
        float animationLength = PatAPoke.CONFIG.animationLengthSeconds();
        SchedulingFunctionsKt.afterOnServer((float)((float)((double)animationLength * ANIMATION_PHASES[0])), () -> {
            if (!PettingHandler.isValid(player, pokemon)) {
                if (!wasSneaking && shouldCrouch) {
                    player.method_5660(false);
                }
                PettingHandler.releaseLock(pokemon, lock);
                return Unit.INSTANCE;
            }
            player.method_23667(class_1268.field_5810, true);
            PettingHandler.spawnHeartParticles(player.method_51469(), pokemon, 4, 0.01);
            return Unit.INSTANCE;
        });
        SchedulingFunctionsKt.afterOnServer((float)((float)((double)animationLength * ANIMATION_PHASES[1])), () -> {
            if (!PettingHandler.isValid(player, pokemon)) {
                if (!wasSneaking && shouldCrouch) {
                    player.method_5660(false);
                }
                PettingHandler.releaseLock(pokemon, lock);
                return Unit.INSTANCE;
            }
            player.method_23667(class_1268.field_5808, true);
            return Unit.INSTANCE;
        });
        SchedulingFunctionsKt.afterOnServer((float)((float)((double)animationLength * ANIMATION_PHASES[2])), () -> {
            if (!PettingHandler.isValid(player, pokemon)) {
                if (!wasSneaking && shouldCrouch) {
                    player.method_5660(false);
                }
                PettingHandler.releaseLock(pokemon, lock);
                return Unit.INSTANCE;
            }
            player.method_23667(class_1268.field_5810, true);
            return Unit.INSTANCE;
        });
        SchedulingFunctionsKt.afterOnServer((float)((float)((double)animationLength * ANIMATION_PHASES[3])), () -> {
            if (!PettingHandler.isValid(player, pokemon)) {
                PettingHandler.releaseLock(pokemon, lock);
                return Unit.INSTANCE;
            }
            PettingHandler.finishPetting(player, pokemon, lock, wasSneaking, shouldCrouch);
            return Unit.INSTANCE;
        });
    }

    private static void finishPetting(class_3222 player, PokemonEntity pokemon, Object lock, boolean wasSneaking, boolean shouldCrouch) {
        if (!PettingHandler.isValid(player, pokemon)) {
            PettingHandler.releaseLock(pokemon, lock);
            return;
        }
        if (!wasSneaking && shouldCrouch) {
            player.method_5660(false);
        }
        class_3218 level = player.method_51469();
        PettingHandler.spawnHeartParticles(level, pokemon, 8, 0.02);
        FriendshipResult result = PettingHandler.applyFriendshipGain(pokemon);
        if (result == FriendshipResult.GAINED) {
            player.method_7353((class_2561)class_2561.method_43469((String)"message.patapoke.petting.friendship_gain", (Object[])new Object[]{PatAPoke.CONFIG.friendshipGain()}), true);
        }
        PettingHandler.releaseLock(pokemon, lock);
    }

    private static void guidePokemonTowardPlayer(PokemonEntity pokemon, class_3222 player) {
        class_243 target = player.method_19538();
        pokemon.getNavigation().method_6337(target.field_1352, target.field_1351, target.field_1350, 1.15);
        pokemon.method_5988().method_6226((class_1297)player, 45.0f, 45.0f);
    }

    private static void facePokemon(class_3222 player, PokemonEntity pokemon) {
        PettingHandler.facePokemon(player, pokemon, 0.0);
    }

    private static void facePokemon(class_3222 player, PokemonEntity pokemon, double verticalOffset) {
        class_243 target = PettingHandler.getPokemonHeadPosition(pokemon).method_1031(0.0, verticalOffset, 0.0);
        player.method_5702(class_2183.class_2184.field_9851, target);
    }

    private static boolean isValid(class_3222 player, PokemonEntity pokemon) {
        return pokemon.method_5805() && player.method_51469() == pokemon.method_37908() && !pokemon.getPokemon().isFainted();
    }

    private static void playPetAnimation(PokemonEntity pokemon) {
        String speciesName = pokemon.getPokemon().getSpecies().getName();
        if (speciesName == null || speciesName.isBlank()) {
            return;
        }
        LinkedHashSet<CallSite> animations = new LinkedHashSet<CallSite>(List.of("animation." + speciesName + ".happy", "animation." + speciesName + ".interaction", "animation." + speciesName + ".ground_idle"));
        PokemonSideDelegate delegate = pokemon.getDelegate();
        if (delegate instanceof PosableState) {
            PosableState posableState = (PosableState)delegate;
            posableState.addFirstAnimation(animations);
            return;
        }
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            PlayPosableAnimationPacket packet = new PlayPosableAnimationPacket(pokemon.method_5628(), animations, Collections.emptyList());
            for (class_3222 nearbyPlayer : serverLevel.method_18456()) {
                if (!(nearbyPlayer.method_5739((class_1297)pokemon) < 128.0f)) continue;
                packet.sendToPlayer(nearbyPlayer);
            }
        }
    }

    private static void spawnHeartParticles(class_3218 level, PokemonEntity pokemon, int count, double speed) {
        class_243 pos = PettingHandler.getPokemonHeadPosition(pokemon).method_1031(0.0, 0.15, 0.0);
        level.method_14199((class_2394)class_2398.field_11201, pos.field_1352, pos.field_1351, pos.field_1350, count, 0.35, 0.25, 0.35, speed);
    }

    private static void releaseLock(PokemonEntity pokemon, Object lock) {
        pokemon.getBusyLocks().remove(lock);
    }

    private static class_243 getPokemonHeadPosition(PokemonEntity pokemon) {
        return new class_243(pokemon.method_23317(), pokemon.method_23320(), pokemon.method_23321());
    }

    private static FriendshipResult applyFriendshipGain(PokemonEntity pokemon) {
        long now = pokemon.method_37908().method_8510();
        long cooldownTicks = PatAPoke.CONFIG.cooldownTicks();
        Long lastGain = FRIENDSHIP_COOLDOWNS.get(pokemon.method_5667());
        if (lastGain != null && now - lastGain < cooldownTicks) {
            return FriendshipResult.ON_COOLDOWN;
        }
        int gain = PatAPoke.CONFIG.friendshipGain();
        if (gain > 0) {
            pokemon.getPokemon().incrementFriendship(gain, true);
        }
        FRIENDSHIP_COOLDOWNS.put(pokemon.method_5667(), now);
        return gain > 0 ? FriendshipResult.GAINED : FriendshipResult.SKIPPED;
    }

    private static enum FriendshipResult {
        GAINED,
        ON_COOLDOWN,
        SKIPPED;

    }
}

