package com.patapoke;

import com.patapoke.network.PetPokemonPayload;
import com.patapoke.petting.PettingHandler;
import com.patapoke.config.PatAPokeConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatAPoke implements ModInitializer {
    public static final String MOD_ID = "patapoke";
    public static final Logger LOGGER = LoggerFactory.getLogger("Pat a Poke");
    public static PatAPokeConfig CONFIG;

    @Override
    public void onInitialize() {
        CONFIG = PatAPokeConfig.load(LOGGER);
        PayloadTypeRegistry.playC2S().register(PetPokemonPayload.TYPE, PetPokemonPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PetPokemonPayload.TYPE, (payload, context) ->
            PettingHandler.startPetting(context.player(), payload.pokemonId())
        );
        LOGGER.info("Loaded Pat a Poke.");
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath(MOD_ID, path);
    }
}
