package com.patapoke.network;

import com.patapoke.PatAPoke;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record PetPokemonPayload(UUID pokemonId) implements CustomPacketPayload {
    public static final ResourceLocation ID = PatAPoke.id("pet_pokemon");
    public static final Type<PetPokemonPayload> TYPE = new Type<>(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PetPokemonPayload> CODEC = StreamCodec.ofMember(
        PetPokemonPayload::write,
        PetPokemonPayload::read
    );

    private static PetPokemonPayload read(RegistryFriendlyByteBuf buf) {
        return new PetPokemonPayload(buf.readUUID());
    }

    private void write(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(pokemonId);
    }

    @Override
    public Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}
