package com.patapoke.client;

import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.interaction.PokemonInteractionGUICreationEvent;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.patapoke.PatAPoke;
import com.patapoke.network.PetPokemonPayload;
import kotlin.Unit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import org.joml.Vector3f;

public class PatAPokeClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        CobblemonEvents.POKEMON_INTERACTION_GUI_CREATION.subscribe(this::addPetOption);
    }

    private void addPetOption(PokemonInteractionGUICreationEvent event) {
        Minecraft client = Minecraft.getInstance();
        boolean canPet = ClientPlayNetworking.canSend(PetPokemonPayload.TYPE);

        boolean finalCanPet = canPet;
        InteractWheelOption option = new InteractWheelOption(
            PatAPoke.id("textures/gui/interact/pet.png"),
            null,
            finalCanPet,
            "patapoke.ui.interact.pet",
            () -> (Vector3f) null,
            () -> {
                if (finalCanPet) {
                    ClientPlayNetworking.send(new PetPokemonPayload(event.getPokemonID()));
                    client.setScreen(null);
                }
                return Unit.INSTANCE;
            }
        );

        event.addFillingOption(option);
    }
}
