/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.builders.types;

import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.builders.InventoryBuilder;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.economy.CurrencyAPI;
import com.badbones69.crazyenchantments.paper.api.managers.ShopManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ShopMenu
extends InventoryBuilder {
    @NotNull
    private final Starter starter;
    @NotNull
    private final CurrencyAPI currencyAPI;
    private final ShopManager shopManager;

    public ShopMenu(Player player, int size, String title) {
        super(player, size, title);
        this.starter = this.plugin.getStarter();
        this.currencyAPI = this.starter.getCurrencyAPI();
        this.shopManager = this.starter.getShopManager();
    }

    @Override
    public InventoryBuilder build() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        for (Currency currency : Currency.values()) {
            placeholders.put("%" + currency.getName() + "%", String.valueOf(this.currencyAPI.getCurrency(this.getPlayer(), currency)));
        }
        for (Map.Entry entry : this.shopManager.getCustomizerItems().entrySet()) {
            ((ItemBuilder)entry.getKey()).setNamePlaceholders(placeholders).setLorePlaceholders(placeholders);
            this.getInventory().setItem(((Integer)entry.getValue()).intValue(), ((ItemBuilder)entry.getKey()).build());
        }
        this.shopManager.getShopItems().keySet().forEach(itemBuilder -> this.getInventory().setItem(this.shopManager.getShopItems().get(itemBuilder).intValue(), itemBuilder.build()));
        return this;
    }
}

