/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.controllers.settings;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.Enchant;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.EnchantedBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.objects.LostBook;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.google.common.collect.Lists;
import com.ryderbelserion.fusion.paper.FusionPaper;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentBookSettings {
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final FusionPaper fusion = this.plugin.getFusion();
    private ItemBuilder enchantmentBook;
    private final List<Category> categories = Lists.newArrayList();
    private final List<CEnchantment> registeredEnchantments = Lists.newArrayList();

    public boolean useUnsafeEnchantments() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        return config.getBoolean("Settings.EnchantmentOptions.UnSafe-Enchantments");
    }

    @Nullable
    public CEBook getCEBook(ItemStack book) {
        PersistentDataContainerView view = book.getPersistentDataContainer();
        if (!view.has(DataKeys.stored_enchantments.getNamespacedKey())) {
            return null;
        }
        EnchantedBook data = Methods.getGson().fromJson((String)view.get(DataKeys.stored_enchantments.getNamespacedKey(), PersistentDataType.STRING), EnchantedBook.class);
        CEnchantment enchantment = null;
        for (CEnchantment enchant : this.getRegisteredEnchantments()) {
            if (!enchant.getName().equalsIgnoreCase(data.getName())) continue;
            enchantment = enchant;
            break;
        }
        return new CEBook(enchantment, data.getLevel(), book.getAmount()).setSuccessRate(data.getSuccessChance()).setDestroyRate(data.getDestroyChance());
    }

    @Nullable
    public ItemStack getNewScrambledBook(ItemStack book) {
        PersistentDataContainerView view = book.getPersistentDataContainer();
        EnchantedBook data = Methods.getGson().fromJson((String)view.get(DataKeys.stored_enchantments.getNamespacedKey(), PersistentDataType.STRING), EnchantedBook.class);
        CEnchantment enchantment = null;
        int bookLevel = 0;
        for (CEnchantment enchantment1 : this.getRegisteredEnchantments()) {
            if (!enchantment1.getName().equalsIgnoreCase(data.getName())) continue;
            enchantment = enchantment1;
            bookLevel = data.getLevel();
        }
        if (enchantment == null) {
            return null;
        }
        return new CEBook(enchantment, bookLevel, EnchantUtils.getHighestEnchantmentCategory(enchantment)).buildBook();
    }

    public boolean isEnchantmentBook(ItemStack book) {
        if (book == null) {
            return false;
        }
        PersistentDataContainerView view = book.getPersistentDataContainer();
        if (!view.has(DataKeys.stored_enchantments.getNamespacedKey())) {
            return false;
        }
        String dataString = (String)view.get(DataKeys.stored_enchantments.getNamespacedKey(), PersistentDataType.STRING);
        EnchantedBook data = Methods.getGson().fromJson(dataString, EnchantedBook.class);
        for (CEnchantment enchantment : this.getRegisteredEnchantments()) {
            if (!enchantment.getName().equalsIgnoreCase(data.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<CEnchantment> getRegisteredEnchantments() {
        return this.registeredEnchantments;
    }

    public ItemBuilder getNormalBook() {
        return new ItemBuilder(this.enchantmentBook);
    }

    @NotNull
    public ItemStack getEnchantmentBookItem() {
        return new ItemBuilder(this.enchantmentBook).build();
    }

    public void setEnchantmentBook(@NotNull ItemBuilder enchantmentBook) {
        this.enchantmentBook = enchantmentBook;
    }

    @NotNull
    public Map<CEnchantment, Integer> getEnchantments(@Nullable ItemStack item) {
        if (item == null) {
            return Collections.emptyMap();
        }
        PersistentDataContainerView view = item.getPersistentDataContainer();
        HashMap<CEnchantment, Integer> enchantments = new HashMap<CEnchantment, Integer>();
        String data = (String)view.get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING);
        if (data == null) {
            return Collections.emptyMap();
        }
        Enchant enchants = Methods.getGson().fromJson(data, Enchant.class);
        if (enchants.isEmpty()) {
            return Collections.emptyMap();
        }
        for (CEnchantment enchantment : this.getRegisteredEnchantments()) {
            if (!enchantment.isActivated() || !enchants.hasEnchantment(enchantment.getName())) continue;
            enchantments.put(enchantment, enchants.getLevel(enchantment.getName()));
        }
        return enchantments;
    }

    public List<CEnchantment> getEnchantmentsOnItem(ItemStack item) {
        return new ArrayList<CEnchantment>(this.getEnchantments(item).keySet());
    }

    public int getEnchantmentAmount(@NotNull ItemStack item, boolean includeVanillaEnchantments) {
        int amount = this.getEnchantments(item).size();
        if (includeVanillaEnchantments && item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENTS)) {
            amount += item.getEnchantments().size();
        }
        return amount;
    }

    @NotNull
    public List<Category> getCategories() {
        return this.categories;
    }

    public void populateMaps() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        ConfigurationSection section = config.getConfigurationSection("Categories");
        if (section == null) {
            this.fusion.log("warn", "The categories section cannot be found in config.yml, It's possible the file is badly formatted!", new Object[0]);
            return;
        }
        for (String category : section.getKeys(false)) {
            String path = "Categories." + category;
            LostBook lostBook = new LostBook(config.getInt(path + ".LostBook.Slot"), config.getBoolean(path + ".LostBook.InGUI"), new ItemBuilder().setMaterial(config.getString(path + ".LostBook.Item", "BOOK")).setPlayerName(config.getString(path + ".LostBook.Player", "")).setName(config.getString(path + ".LostBook.Name", "Error getting name.")).setLore(config.getStringList(path + ".LostBook.Lore")).setGlow(config.getBoolean(path + ".LostBook.Glowing", true)), config.getInt(path + ".LostBook.Cost"), Currency.getCurrency(config.getString(path + ".LostBook.Currency")), config.getBoolean(path + ".LostBook.FireworkToggle", false), this.getColors(config.getString(path + ".LostBook.FireworkColors", "Red, White, Blue")), config.getBoolean(path + ".LostBook.Sound-Toggle", false), config.getString(path + ".LostBook.Sound", "BLOCK_ANVIL_PLACE"));
            this.categories.add(new Category(category, config.getInt(path + ".Slot"), config.getBoolean(path + ".InGUI", true), new ItemBuilder().setMaterial(config.getString(path + ".Item", ColorUtils.getRandomPaneColor().getName())).setPlayerName(config.getString(path + ".Player", "")).setName(config.getString(path + ".Name", "Error getting name.")).setLore(config.getStringList(path + ".Lore")).setGlow(config.getBoolean(path + ".Glowing", false)), config.getInt(path + ".Cost"), Currency.getCurrency(config.getString(path + ".Currency")), config.getInt(path + ".Rarity"), lostBook, config.getInt(path + ".EnchOptions.SuccessPercent.Max"), config.getInt(path + ".EnchOptions.SuccessPercent.Min"), config.getInt(path + ".EnchOptions.DestroyPercent.Max"), config.getInt(path + ".EnchOptions.DestroyPercent.Min"), config.getBoolean(path + ".EnchOptions.MaxLvlToggle"), config.getInt(path + ".EnchOptions.LvlRange.Max"), config.getInt(path + ".EnchOptions.LvlRange.Min")));
        }
    }

    @Nullable
    public Category getCategory(String name) {
        for (Category category : this.categories) {
            if (!category.getName().equalsIgnoreCase(name)) continue;
            return category;
        }
        return null;
    }

    private List<Color> getColors(String string) {
        ArrayList<Color> colors = new ArrayList<Color>();
        ColorUtils.color(colors, string);
        return colors;
    }

    public int getLevel(@NotNull ItemStack item, @NotNull CEnchantment enchant) {
        int level;
        String data = (String)item.getPersistentDataContainer().get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING);
        int n = level = data == null ? 0 : Methods.getGson().fromJson(data, Enchant.class).getLevel(enchant.getName());
        if (!this.useUnsafeEnchantments() && level > enchant.getMaxLevel()) {
            level = enchant.getMaxLevel();
        }
        return level;
    }

    @NotNull
    public ItemStack removeEnchantment(@NotNull ItemStack itemStack, @NotNull CEnchantment enchant) {
        PersistentDataContainerView view = itemStack.getPersistentDataContainer();
        List lore = itemStack.lore();
        if (lore != null) {
            lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(enchant.getCustomName())));
            itemStack.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(lore).build()));
        }
        Enchant data = view.has(DataKeys.enchantments.getNamespacedKey()) ? Methods.getGson().fromJson((String)view.get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING), Enchant.class) : new Enchant(new HashMap<String, Integer>());
        data.removeEnchantment(enchant.getName());
        if (data.isEmpty() && view.has(DataKeys.enchantments.getNamespacedKey())) {
            itemStack.editPersistentDataContainer(container -> container.remove(DataKeys.enchantments.getNamespacedKey()));
        } else {
            itemStack.editPersistentDataContainer(container -> container.set(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING, (Object)Methods.getGson().toJson(data)));
        }
        return itemStack;
    }

    public void removeEnchantments(@NotNull ItemStack itemStack, @NotNull List<CEnchantment> enchants) {
        PersistentDataContainerView view = itemStack.getPersistentDataContainer();
        List lore = itemStack.lore();
        if (lore != null) {
            for (CEnchantment enchant2 : enchants) {
                lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(enchant2.getCustomName())));
                itemStack.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(lore).build()));
            }
        }
        Enchant data = view.has(DataKeys.enchantments.getNamespacedKey()) ? Methods.getGson().fromJson((String)view.get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING), Enchant.class) : new Enchant(new HashMap<String, Integer>());
        enchants.forEach(enchant -> data.removeEnchantment(enchant.getName()));
        if (data.isEmpty() && view.has(DataKeys.enchantments.getNamespacedKey())) {
            itemStack.editPersistentDataContainer(container -> container.remove(DataKeys.enchantments.getNamespacedKey()));
        } else {
            itemStack.editPersistentDataContainer(container -> container.set(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING, (Object)Methods.getGson().toJson(data)));
        }
    }
}

