/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.files;

import com.ryderbelserion.fusion.core.files.FileManager;
import com.ryderbelserion.fusion.core.files.enums.FileAction;
import com.ryderbelserion.fusion.core.files.interfaces.ICustomFile;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class PaperFileManager
extends FileManager {
    public PaperFileManager(@NotNull FusionPaper fusion) {
        super(fusion);
    }

    public final PaperFileManager addPaperFile(@NotNull Path path, @NotNull Consumer<PaperCustomFile> consumer) {
        if (this.files.containsKey(path)) {
            ((ICustomFile)this.files.get(path)).load();
            return this;
        }
        this.addFile(path, (ICustomFile)new PaperCustomFile(this, path, consumer).load());
        return this;
    }

    public final PaperFileManager addPaperFolder(@NotNull Path folder, @NotNull Consumer<PaperCustomFile> consumer) {
        this.extractFolder(folder.getFileName().toString(), folder.getParent());
        for (Path path : this.fusion.getFiles(folder, ".yml", this.fusion.getConfig().getDepth())) {
            this.addPaperFile(path, consumer);
        }
        return this;
    }

    public final PaperFileManager addPaperFolder(@NotNull Path folder) {
        return this.addPaperFolder(folder, consumer -> consumer.addAction(FileAction.EXTRACT_FOLDER));
    }

    @NotNull
    public final Optional<PaperCustomFile> getPaperFile(@NotNull Path path) {
        return this.getFile(path).map(PaperCustomFile.class::cast);
    }
}

