/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.managers;

import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class WingsManager {
    private boolean isWingsEnabled;
    private boolean isCloudsEnabled;
    private boolean isEnemyCheckEnabled;
    private int enemyRadius;
    private final List<UUID> flyingPlayers = new ArrayList<UUID>();
    private final List<String> whitelistWorlds = new ArrayList<String>();
    private final List<String> blacklistWorlds = new ArrayList<String>();
    private List<String> regions;
    private final List<String> limitlessFlightWorlds = new ArrayList<String>();
    private boolean ownersCanFly;
    private boolean membersCanFly;
    private ScheduledTask wingsTask;

    public void load() {
        this.isWingsEnabled = CEnchantments.WINGS.isActivated();
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        String path = "Settings.EnchantmentOptions.Wings.";
        this.isCloudsEnabled = config.getBoolean(path + "Clouds");
        this.isEnemyCheckEnabled = config.getBoolean(path + "Enemy-Toggle");
        this.enemyRadius = config.getInt(path + "Distance", 10);
        this.whitelistWorlds.clear();
        config.getStringList(path + "Worlds.Whitelisted").forEach(world -> this.whitelistWorlds.add(world.toLowerCase()));
        this.blacklistWorlds.clear();
        config.getStringList(path + "Worlds.Blacklisted").forEach(world -> this.blacklistWorlds.add(world.toLowerCase()));
        this.limitlessFlightWorlds.clear();
        config.getStringList(path + "Worlds.Limitless-Flight-Worlds").forEach(world -> this.limitlessFlightWorlds.add(world.toLowerCase()));
        this.regions = config.getStringList(path + "Regions");
        this.ownersCanFly = config.getBoolean(path + "Owners-Can-Fly", true);
        this.membersCanFly = config.getBoolean(path + "Members-Can-Fly", true);
    }

    public boolean isWingsEnabled() {
        return this.isWingsEnabled;
    }

    public boolean isCloudsEnabled() {
        return this.isCloudsEnabled;
    }

    public boolean isEnemyCheckEnabled() {
        return this.isEnemyCheckEnabled;
    }

    public int getEnemyRadius() {
        return this.enemyRadius;
    }

    public List<UUID> getFlyingPlayers() {
        return this.flyingPlayers;
    }

    public boolean isFlyingPlayer(Player player) {
        return this.flyingPlayers.contains(player.getUniqueId());
    }

    public void addFlyingPlayer(Player player) {
        if (!this.flyingPlayers.contains(player.getUniqueId())) {
            this.flyingPlayers.add(player.getUniqueId());
        }
    }

    public void removeFlyingPlayer(Player player) {
        this.flyingPlayers.remove(player.getUniqueId());
    }

    public List<String> getLimitlessFlightWorlds() {
        return this.limitlessFlightWorlds;
    }

    public boolean inLimitlessFlightWorld(Player player) {
        return player != null && this.limitlessFlightWorlds.contains(player.getWorld().getName().toLowerCase());
    }

    public List<String> getWhitelistedWorlds() {
        return this.whitelistWorlds;
    }

    public boolean inWhitelistedWorld(Player player) {
        return player != null && this.whitelistWorlds.contains(player.getWorld().getName().toLowerCase());
    }

    public List<String> getBlacklistedWorlds() {
        return this.blacklistWorlds;
    }

    public boolean inBlacklistedWorld(Player player) {
        return player != null && this.blacklistWorlds.contains(player.getWorld().getName().toLowerCase());
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public boolean canOwnersFly() {
        return this.ownersCanFly;
    }

    public boolean canMembersFly() {
        return this.membersCanFly;
    }

    public void setWingsTask(ScheduledTask task) {
        this.endWingsTask();
        this.wingsTask = task;
    }

    public void endWingsTask() {
        if (this.wingsTask != null) {
            this.wingsTask.cancel();
        }
    }
}

