/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.listeners;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ScramblerListener
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private final HashMap<Player, ScheduledTask> roll = new HashMap();
    private ItemBuilder scramblerItem;
    private ItemBuilder pointer;
    private boolean animationToggle;
    private String guiName;

    public void loadScrambler() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        this.scramblerItem = new ItemBuilder().setMaterial(config.getString("Settings.Scrambler.Item", "SUNFLOWER")).setItemModel(config.getString("Settings.Scrambler.Item.Model.Namespace", ""), config.getString("Settings.Scrambler.Item.Model.Key", "")).setName(config.getString("Settings.Scrambler.Name", "Error getting name.")).setLore(config.getStringList("Settings.Scrambler.Lore")).setGlow(config.getBoolean("Settings.Scrambler.Glowing", false));
        this.pointer = new ItemBuilder().setMaterial(config.getString("Settings.Scrambler.GUI.Pointer.Item", "REDSTONE_TORCH")).setItemModel(config.getString("Settings.Scrambler.GUI.Pointer.Item.Model.Namespace", ""), config.getString("Settings.Scrambler.GUI.Pointer.Item.Model.Key", "")).setName(config.getString("Settings.Scrambler.GUI.Pointer.Name", "Error getting name.")).setLore(config.getStringList("Settings.Scrambler.GUI.Pointer.Lore"));
        this.animationToggle = FileManager.Files.CONFIG.getFile().getBoolean("Settings.Scrambler.GUI.Toggle", true);
        this.guiName = ColorUtils.color(FileManager.Files.CONFIG.getFile().getString("Settings.Scrambler.GUI.Name", "Error getting name."));
    }

    public ItemStack getScramblers() {
        return this.getScramblers(1);
    }

    public ItemStack getScramblers(int amount) {
        ItemStack item = this.scramblerItem.setAmount(amount).build();
        item.editPersistentDataContainer(container -> container.set(DataKeys.scrambler.getNamespacedKey(), PersistentDataType.BOOLEAN, (Object)true));
        return item;
    }

    public boolean isScrambler(ItemStack item) {
        return item.getPersistentDataContainer().has(DataKeys.scrambler.getNamespacedKey());
    }

    private void setGlass(Inventory inv) {
        for (int slot = 0; slot < 9; ++slot) {
            if (slot != 4) {
                inv.setItem(slot, ColorUtils.getRandomPaneColor().setName(" ").build());
                inv.setItem(slot + 18, ColorUtils.getRandomPaneColor().setName(" ").build());
                continue;
            }
            inv.setItem(slot, this.pointer.build());
            inv.setItem(slot + 18, this.pointer.build());
        }
    }

    public void openScrambler(Player player, ItemStack book) {
        Inventory inventory = this.plugin.getServer().createInventory(null, 27, this.guiName);
        this.setGlass(inventory);
        for (int slot = 9; slot > 8 && slot < 18; ++slot) {
            inventory.setItem(slot, this.enchantmentBookSettings.getNewScrambledBook(book));
        }
        player.openInventory(inventory);
        this.startScrambler(player, inventory, book);
    }

    private void startScrambler(final Player player, final Inventory inventory, final ItemStack book) {
        this.roll.put(player, new FoliaScheduler(this.plugin, null, (Entity)player){
            int time;
            int full;
            int open;
            {
                super(arg0, arg1, arg2);
                this.time = 1;
                this.full = 0;
                this.open = 0;
            }

            @Override
            public void run() {
                if (this.full <= 50) {
                    ScramblerListener.this.moveItems(inventory, book);
                    ScramblerListener.this.setGlass(inventory);
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                }
                ++this.open;
                if (this.open >= 5) {
                    player.openInventory(inventory);
                    this.open = 0;
                }
                ++this.full;
                if (this.full > 51) {
                    if (ScramblerListener.this.slowSpin().contains(this.time)) {
                        ScramblerListener.this.moveItems(inventory, book);
                        ScramblerListener.this.setGlass(inventory);
                        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    }
                    ++this.time;
                    if (this.time == 60) {
                        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                        this.cancel();
                        ScramblerListener.this.roll.remove(player);
                        ItemStack item = inventory.getItem(13);
                        if (item != null) {
                            ItemStack clone = item.withType(ScramblerListener.this.enchantmentBookSettings.getEnchantmentBookItem().getType());
                            ScramblerListener.this.methods.setDurability(item, ScramblerListener.this.methods.getDurability(ScramblerListener.this.enchantmentBookSettings.getEnchantmentBookItem()));
                            ScramblerListener.this.methods.addItemToInventory(player, clone);
                        } else {
                            ScramblerListener.this.logger.error("The item at slot 13 is null, We cannot continue!");
                        }
                    } else if (this.time > 60) {
                        this.cancel();
                    }
                }
            }
        }.runAtFixedRate(1L, 1L));
    }

    private List<Integer> slowSpin() {
        ArrayList<Integer> slow = new ArrayList<Integer>();
        int full = 120;
        int cut = 15;
        int amount = 120;
        while (cut > 0) {
            if (full <= amount - cut || full >= amount - cut) {
                slow.add(amount);
                amount -= cut;
                --cut;
            }
            --full;
        }
        return slow;
    }

    private void moveItems(Inventory inv, ItemStack book) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int slot = 9; slot > 8 && slot < 17; ++slot) {
            items.add(inv.getItem(slot));
        }
        ItemStack newBook = this.enchantmentBookSettings.getNewScrambledBook(book);
        newBook.setType(ColorUtils.getRandomPaneColor().getMaterial());
        inv.setItem(9, newBook);
        for (int amount = 0; amount < 8; ++amount) {
            inv.setItem(amount + 10, (ItemStack)items.get(amount));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onReRoll(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() == null) {
            return;
        }
        ItemStack book = event.getCurrentItem() != null ? event.getCurrentItem() : new ItemStack(Material.AIR);
        ItemStack scrambler = event.getCursor();
        if (book.getType() == Material.AIR || scrambler.getType() == Material.AIR) {
            return;
        }
        if (book.getAmount() != 1 || scrambler.getAmount() != 1) {
            return;
        }
        if (!this.isScrambler(scrambler) || !this.enchantmentBookSettings.isEnchantmentBook(book)) {
            return;
        }
        if (event.getClickedInventory().getType() != InventoryType.PLAYER) {
            player.sendMessage(Messages.NEED_TO_USE_PLAYER_INVENTORY.getMessage());
            return;
        }
        event.setCancelled(true);
        player.setItemOnCursor(new ItemStack(Material.AIR));
        if (this.animationToggle) {
            event.setCurrentItem(new ItemStack(Material.AIR));
            this.openScrambler(player, book);
        } else {
            event.setCurrentItem(this.enchantmentBookSettings.getNewScrambledBook(book));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInvClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals(this.guiName)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onScramblerClick(PlayerInteractEvent event) {
        ItemStack item = this.methods.getItemInHand(event.getPlayer());
        if (item.isEmpty()) {
            return;
        }
        if (item.getPersistentDataContainer().has(DataKeys.scrambler.getNamespacedKey())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        try {
            this.roll.get(player).cancel();
            this.roll.remove(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onScrollClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.isScrambler(player.getInventory().getItemInMainHand()) || this.isScrambler(player.getInventory().getItemInOffHand())) {
            event.setCancelled(true);
        }
    }
}

