/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.builder;

import ch.jalu.configme.properties.MapProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.builder.PropertyBuilderUtils;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class MapPropertyBuilder<V, M extends Map<String, V>, P extends Property<M>> {
    private String path;
    private final M defaultValue;
    private final BiFunction<String, M, P> createPropertyFunction;

    public MapPropertyBuilder(@NotNull BiFunction<String, M, P> createPropertyFunction, @NotNull M defaultValue) {
        this.createPropertyFunction = createPropertyFunction;
        this.defaultValue = defaultValue;
    }

    @NotNull
    public static <V> MapPropertyBuilder<V, Map<String, V>, MapProperty<V>> mapBuilder(@NotNull PropertyType<V> valueType) {
        return new MapPropertyBuilder((path, defVal) -> new MapProperty((String)path, valueType, defVal), new LinkedHashMap());
    }

    @NotNull
    public MapPropertyBuilder<V, M, P> path(@NotNull String path) {
        this.path = path;
        return this;
    }

    @NotNull
    public MapPropertyBuilder<V, M, P> defaultValue(@NotNull Map<String, V> defaultValue) {
        PropertyBuilderUtils.verifyDefaultValueIsEmpty(this.defaultValue.isEmpty());
        this.defaultValue.putAll(defaultValue);
        return this;
    }

    @NotNull
    public MapPropertyBuilder<V, M, P> addToDefaultValue(@NotNull String key, @NotNull V value) {
        this.defaultValue.put((String)key, value);
        return this;
    }

    @NotNull
    public MapPropertyBuilder<V, M, P> addToDefaultValue(@NotNull Map.Entry<String, V> entry) {
        return this.addToDefaultValue(entry.getKey(), entry.getValue());
    }

    @NotNull
    public P build() {
        PropertyBuilderUtils.requireNonNullPath(this.path);
        return (P)((Property)this.createPropertyFunction.apply(this.path, this.defaultValue));
    }
}

