/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.controllers.settings;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ProtectionCrystalSettings {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final String protectionString = ColorUtils.color(FileManager.Files.CONFIG.getFile().getString("Settings.ProtectionCrystal.Protected"));
    private final HashMap<UUID, List<ItemStack>> crystalItems = new HashMap();
    private ItemBuilder crystal;

    public void loadProtectionCrystal() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        this.crystal = new ItemBuilder().setMaterial(config.getString("Settings.ProtectionCrystal.Item", "EMERALD")).setName(config.getString("Settings.ProtectionCrystal.Name", "Error getting name.")).setLore(config.getStringList("Settings.ProtectionCrystal.Lore")).setGlow(config.getBoolean("Settings.ProtectionCrystal.Glowing", false));
    }

    public final ItemStack getCrystal() {
        return this.getCrystal(1);
    }

    public final ItemStack getCrystal(int amount) {
        ItemStack item = this.crystal.setAmount(amount).build();
        item.editPersistentDataContainer(container -> container.set(DataKeys.protection_crystal.getNamespacedKey(), PersistentDataType.BOOLEAN, (Object)true));
        return item;
    }

    public void addPlayer(Player player, List<ItemStack> items) {
        this.crystalItems.put(player.getUniqueId(), items);
    }

    public void removePlayer(Player player) {
        this.crystalItems.remove(player.getUniqueId());
    }

    public boolean containsPlayer(Player player) {
        return this.crystalItems.containsKey(player.getUniqueId());
    }

    public List<ItemStack> getPlayer(Player player) {
        return this.crystalItems.get(player.getUniqueId());
    }

    public HashMap<UUID, List<ItemStack>> getCrystalItems() {
        return this.crystalItems;
    }

    public boolean isProtectionSuccessful(Player player) {
        if (player.hasPermission("crazyenchantments.bypass.protectioncrystal")) {
            return true;
        }
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        if (config.getBoolean("Settings.ProtectionCrystal.Chance.Toggle", false)) {
            return this.methods.randomPicker(config.getInt("Settings.ProtectionCrystal.Chance.Success-Chance", 100), 100);
        }
        return true;
    }

    public static boolean isProtected(PersistentDataContainerView data) {
        return data.has(DataKeys.protected_item.getNamespacedKey());
    }

    public boolean isProtectionCrystal(ItemStack item) {
        return item.getPersistentDataContainer().has(DataKeys.protection_crystal.getNamespacedKey());
    }

    public final ItemStack removeProtection(ItemStack item) {
        List lore;
        PersistentDataContainerView view = item.getPersistentDataContainer();
        if (view.has(DataKeys.protected_item.getNamespacedKey())) {
            item.editPersistentDataContainer(container -> container.remove(DataKeys.protected_item.getNamespacedKey()));
        }
        if ((lore = item.lore()) != null) {
            lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(this.protectionString)));
            item.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(lore).build()));
        }
        return item;
    }

    public final ItemStack addProtection(ItemStack item) {
        List itemLore = item.lore();
        List lore = itemLore != null ? itemLore : new ArrayList();
        item.editPersistentDataContainer(container -> container.set(DataKeys.protected_item.getNamespacedKey(), PersistentDataType.BOOLEAN, (Object)true));
        lore.add(ColorUtils.legacyTranslateColourCodes(this.protectionString));
        item.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(lore).build()));
        return item;
    }
}

