/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class HoeEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private final HashMap<UUID, HashMap<Block, BlockFace>> blocks = new HashMap();
    private final Set<Material> harvesterCrops = Set.of(Material.WHEAT, Material.CARROTS, Material.BEETROOTS, Material.POTATOES, Material.NETHER_WART, Material.COCOA);
    private final Set<Material> seedlings = Set.of(Material.WHEAT, Material.CARROTS, Material.BEETROOTS, Material.POTATOES, Material.NETHER_WART, Material.COCOA, Material.MELON_STEM, Material.CRIMSON_STEM, Material.PUMPKIN_STEM, Material.WARPED_STEM);
    private final HashMap<Material, Material> planterSeeds = new HashMap<Material, Material>(){
        {
            this.put(Material.WHEAT_SEEDS, Material.WHEAT);
            this.put(Material.BEETROOT_SEEDS, Material.BEETROOTS);
            this.put(Material.POTATO, Material.POTATOES);
            this.put(Material.CARROT, Material.CARROTS);
            this.put(Material.NETHER_WART, Material.NETHER_WART);
            this.put(Material.MELON_SEEDS, Material.MELON_STEM);
            this.put(Material.PUMPKIN_SEEDS, Material.PUMPKIN_STEM);
        }
    };

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack hoe = this.methods.getItemInHand(player);
            Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(hoe);
            if (this.seedlings.contains(block.getType()) && !this.crazyManager.getNMSSupport().isFullyGrown(block) && EnchantUtils.isEventActive(CEnchantments.GREENTHUMB, (Entity)player, hoe, enchantments)) {
                this.fullyGrowPlant(block);
                if (player.getGameMode() != GameMode.CREATIVE) {
                    this.methods.removeDurability(hoe, player);
                }
            }
            if (block.getType() == Material.GRASS_BLOCK || block.getType() == Material.DIRT || block.getType() == Material.SOUL_SAND || block.getType() == Material.FARMLAND) {
                boolean hasGreenThumb;
                boolean bl = hasGreenThumb = CEnchantments.GREENTHUMB.isActivated() && enchantments.containsKey(CEnchantments.GREENTHUMB.getEnchantment());
                if (EnchantUtils.isEventActive(CEnchantments.TILLER, (Entity)player, hoe, enchantments)) {
                    for (Block soil : this.getSoil(player, block)) {
                        if (soil.getType() != Material.FARMLAND && soil.getType() != Material.SOUL_SAND) {
                            soil.setType(Material.FARMLAND);
                        }
                        if (soil.getType() != Material.SOUL_SAND) {
                            for (Block water : this.getAreaBlocks(soil, 4)) {
                                if (water.getType() != Material.WATER) continue;
                                this.crazyManager.getNMSSupport().hydrateSoil(soil);
                                break;
                            }
                        }
                        if (enchantments.containsKey(CEnchantments.PLANTER.getEnchantment())) {
                            this.plantSeedSuccess(soil, player, hasGreenThumb);
                        }
                        if (player.getGameMode() == GameMode.CREATIVE) continue;
                        this.methods.removeDurability(hoe, player);
                    }
                }
                if (player.getGameMode() != GameMode.CREATIVE && CEnchantments.PLANTER.isActivated() && enchantments.containsKey(CEnchantments.PLANTER.getEnchantment()) && !enchantments.containsKey(CEnchantments.TILLER.getEnchantment()) && this.plantSeedSuccess(block, player, hasGreenThumb)) {
                    this.methods.removeDurability(hoe, player);
                }
            }
        } else if (event.getAction() == Action.LEFT_CLICK_BLOCK && CEnchantments.HARVESTER.isActivated() && this.enchantmentBookSettings.getEnchantments(this.methods.getItemInHand(player)).containsKey(CEnchantments.HARVESTER.getEnchantment())) {
            HashMap<Block, BlockFace> blockFace = new HashMap<Block, BlockFace>();
            blockFace.put(event.getClickedBlock(), event.getBlockFace());
            this.blocks.put(player.getUniqueId(), blockFace);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!event.isDropItems()) {
            return;
        }
        if (!event.isCancelled() && !EventUtils.isIgnoredEvent((Event)event)) {
            Player player = event.getPlayer();
            Block plant = event.getBlock();
            if (!this.harvesterCrops.contains(plant.getType())) {
                return;
            }
            ItemStack hoe = this.methods.getItemInHand(player);
            Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(hoe);
            if (!this.blocks.containsKey(player.getUniqueId())) {
                return;
            }
            if (!EnchantUtils.isEventActive(CEnchantments.HARVESTER, (Entity)player, hoe, enchantments)) {
                return;
            }
            BlockFace blockFace = this.blocks.get(player.getUniqueId()).get(plant);
            this.blocks.remove(player.getUniqueId());
            if (!this.crazyManager.getNMSSupport().isFullyGrown(plant)) {
                return;
            }
            this.getAreaCrops(plant, blockFace).forEach(block -> this.methods.playerBreakBlock(player, (Block)block, hoe, true));
        }
    }

    private void fullyGrowPlant(Block block) {
        this.crazyManager.getNMSSupport().fullyGrowPlant(block);
        block.getLocation().getWorld().spawnParticle(Particle.HAPPY_VILLAGER, block.getLocation(), 20, 0.25, 0.25, 0.25);
    }

    private boolean plantSeedSuccess(Block soil, Player player, boolean hasGreenThumb) {
        boolean isSoulSand = soil.getType() == Material.SOUL_SAND;
        Block plant = soil.getLocation().add(0.0, 1.0, 0.0).getBlock();
        if (!plant.isEmpty()) {
            return false;
        }
        Material seedType = this.getPlanterSeed(player.getEquipment().getItemInOffHand());
        ItemStack playerSeedItem = player.getEquipment().getItemInOffHand();
        if (isSoulSand) {
            if (playerSeedItem.getType() != Material.NETHER_WART) {
                seedType = null;
            }
        } else if (playerSeedItem.getType() == Material.NETHER_WART) {
            seedType = null;
        }
        if (seedType == null) {
            for (int slot = 0; slot < 9; ++slot) {
                seedType = this.getPlanterSeed(player.getInventory().getItem(slot));
                playerSeedItem = player.getInventory().getItem(slot);
                if (isSoulSand) {
                    if (playerSeedItem != null && playerSeedItem.getType() != Material.NETHER_WART) {
                        seedType = null;
                    }
                } else if (playerSeedItem != null && playerSeedItem.getType() == Material.NETHER_WART) {
                    seedType = null;
                }
                if (seedType != null) break;
            }
        }
        if (seedType != null) {
            if (soil.getType() != Material.FARMLAND && !isSoulSand) {
                soil.setType(Material.FARMLAND);
            }
            if (player.getGameMode() != GameMode.CREATIVE) {
                this.methods.removeItem(playerSeedItem, player);
            }
            plant.setType(seedType);
            if (hasGreenThumb) {
                this.fullyGrowPlant(plant);
            }
            return true;
        }
        return false;
    }

    public Material getPlanterSeed(ItemStack item) {
        if (item == null) {
            return null;
        }
        return this.planterSeeds.get(item.getType());
    }

    private List<Block> getAreaCrops(Block block, BlockFace blockFace) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (Block crop : this.getAreaBlocks(block, blockFace, 1)) {
            if (!this.harvesterCrops.contains(crop.getType()) || !this.crazyManager.getNMSSupport().isFullyGrown(crop)) continue;
            blockList.add(crop);
        }
        return blockList;
    }

    private List<Block> getSoil(Player player, Block block) {
        ArrayList<Block> soilBlocks = new ArrayList<Block>();
        for (Block soil : this.getAreaBlocks(block, 1)) {
            if (soil.getType() != Material.GRASS_BLOCK && soil.getType() != Material.DIRT && soil.getType() != Material.SOUL_SAND && soil.getType() != Material.FARMLAND) continue;
            BlockBreakEvent useEvent = new BlockBreakEvent(soil, player);
            EventUtils.addIgnoredEvent((Event)useEvent);
            this.plugin.getServer().getPluginManager().callEvent((Event)useEvent);
            if (useEvent.isCancelled()) continue;
            soilBlocks.add(soil);
            EventUtils.removeIgnoredEvent((Event)useEvent);
        }
        return soilBlocks;
    }

    private Set<Block> getAreaBlocks(Block block, int radius) {
        return this.getAreaBlocks(block, BlockFace.UP, radius);
    }

    private Set<Block> getAreaBlocks(Block block, BlockFace blockFace, int radius) {
        Location loc = block.getLocation();
        Location loc2 = block.getLocation();
        switch (blockFace) {
            case SOUTH: {
                loc.add((double)(-radius), (double)radius, 0.0);
                loc2.add((double)radius, (double)(-radius), 0.0);
                break;
            }
            case WEST: {
                loc.add(0.0, (double)radius, (double)(-radius));
                loc2.add(0.0, (double)(-radius), (double)radius);
                break;
            }
            case EAST: {
                loc.add(0.0, (double)radius, (double)radius);
                loc2.add(0.0, (double)(-radius), (double)(-radius));
                break;
            }
            case NORTH: {
                loc.add((double)radius, (double)radius, 0.0);
                loc2.add((double)(-radius), (double)(-radius), 0.0);
                break;
            }
            case UP: {
                loc.add((double)(-radius), 0.0, (double)(-radius));
                loc2.add((double)radius, 0.0, (double)radius);
                break;
            }
            case DOWN: {
                loc.add((double)radius, 0.0, (double)radius);
                loc2.add((double)(-radius), 0.0, (double)(-radius));
                break;
            }
        }
        return this.methods.getEnchantBlocks(loc, loc2);
    }
}

