/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.ArrayProperty;
import ch.jalu.configme.properties.BeanProperty;
import ch.jalu.configme.properties.BooleanProperty;
import ch.jalu.configme.properties.DoubleProperty;
import ch.jalu.configme.properties.EnumProperty;
import ch.jalu.configme.properties.FloatProperty;
import ch.jalu.configme.properties.InlineArrayProperty;
import ch.jalu.configme.properties.IntegerProperty;
import ch.jalu.configme.properties.ListProperty;
import ch.jalu.configme.properties.LongProperty;
import ch.jalu.configme.properties.LowercaseStringSetProperty;
import ch.jalu.configme.properties.MapProperty;
import ch.jalu.configme.properties.OptionalProperty;
import ch.jalu.configme.properties.RegexProperty;
import ch.jalu.configme.properties.SetProperty;
import ch.jalu.configme.properties.ShortProperty;
import ch.jalu.configme.properties.StringListProperty;
import ch.jalu.configme.properties.StringProperty;
import ch.jalu.configme.properties.StringSetProperty;
import ch.jalu.configme.properties.builder.ArrayPropertyBuilder;
import ch.jalu.configme.properties.builder.CollectionPropertyBuilder;
import ch.jalu.configme.properties.builder.MapPropertyBuilder;
import ch.jalu.configme.properties.types.ArrayPropertyType;
import ch.jalu.configme.properties.types.InlineArrayPropertyType;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PropertyInitializer {
    protected PropertyInitializer() {
    }

    @NotNull
    public static BooleanProperty newProperty(@NotNull String path, boolean defaultValue) {
        return new BooleanProperty(path, defaultValue);
    }

    @NotNull
    public static ShortProperty newProperty(@NotNull String path, short defaultValue) {
        return new ShortProperty(path, defaultValue);
    }

    @NotNull
    public static IntegerProperty newProperty(@NotNull String path, int defaultValue) {
        return new IntegerProperty(path, defaultValue);
    }

    @NotNull
    public static LongProperty newProperty(@NotNull String path, long defaultValue) {
        return new LongProperty(path, defaultValue);
    }

    @NotNull
    public static FloatProperty newProperty(@NotNull String path, float defaultValue) {
        return new FloatProperty(path, defaultValue);
    }

    @NotNull
    public static DoubleProperty newProperty(@NotNull String path, double defaultValue) {
        return new DoubleProperty(path, defaultValue);
    }

    @NotNull
    public static StringProperty newProperty(@NotNull String path, @NotNull String defaultValue) {
        return new StringProperty(path, defaultValue);
    }

    @NotNull
    public static <E extends Enum<E>> EnumProperty<E> newProperty(@NotNull Class<E> clazz, @NotNull String path, @NotNull E defaultValue) {
        return new EnumProperty<E>(path, clazz, defaultValue);
    }

    @NotNull
    public static RegexProperty newRegexProperty(@NotNull String path, @NotNull String defaultRegexValue) {
        return new RegexProperty(path, defaultRegexValue);
    }

    @NotNull
    public static RegexProperty newRegexProperty(@NotNull String path, @NotNull Pattern defaultRegexValue) {
        return new RegexProperty(path, defaultRegexValue);
    }

    @NotNull
    public static StringListProperty newListProperty(@NotNull String path, String ... defaultValues) {
        return new StringListProperty(path, defaultValues);
    }

    @NotNull
    public static StringListProperty newListProperty(@NotNull String path, @NotNull List<String> defaultValues) {
        return new StringListProperty(path, defaultValues);
    }

    @NotNull
    public static StringSetProperty newSetProperty(@NotNull String path, String ... defaultValues) {
        return new StringSetProperty(path, defaultValues);
    }

    @NotNull
    public static StringSetProperty newSetProperty(@NotNull String path, @NotNull Set<String> defaultValues) {
        return new StringSetProperty(path, defaultValues);
    }

    @NotNull
    public static LowercaseStringSetProperty newLowercaseStringSetProperty(@NotNull String path, String ... defaultValues) {
        return new LowercaseStringSetProperty(path, defaultValues);
    }

    @NotNull
    public static LowercaseStringSetProperty newLowercaseStringSetProperty(@NotNull String path, @NotNull Collection<String> defaultValues) {
        return new LowercaseStringSetProperty(path, defaultValues);
    }

    @NotNull
    public static <B> BeanProperty<B> newBeanProperty(@NotNull Class<B> beanClass, @NotNull String path, @NotNull B defaultValue) {
        return new BeanProperty<B>(path, beanClass, defaultValue);
    }

    @NotNull
    public static <T> CollectionPropertyBuilder<T, List<T>, ListProperty<T>> listProperty(@NotNull PropertyType<T> type) {
        return CollectionPropertyBuilder.listBuilder(type);
    }

    @NotNull
    public static <T> CollectionPropertyBuilder<T, Set<T>, SetProperty<T>> setProperty(@NotNull PropertyType<T> type) {
        return CollectionPropertyBuilder.setBuilder(type);
    }

    @NotNull
    public static <V> MapPropertyBuilder<V, Map<String, V>, MapProperty<V>> mapProperty(@NotNull PropertyType<V> type) {
        return MapPropertyBuilder.mapBuilder(type);
    }

    @NotNull
    public static <T> ArrayPropertyBuilder<T, ArrayProperty<T>> arrayProperty(@NotNull PropertyType<T> type, @NotNull IntFunction<T[]> arrayProducer) {
        return ArrayPropertyBuilder.arrayBuilder(type, arrayProducer);
    }

    @NotNull
    public static <T> ArrayPropertyBuilder<T, ArrayProperty<T>> arrayProperty(@NotNull ArrayPropertyType<T> arrayType) {
        return ArrayPropertyBuilder.arrayBuilder(arrayType);
    }

    @NotNull
    public static <E> ArrayPropertyBuilder<E, InlineArrayProperty<E>> inlineArrayProperty(@NotNull InlineArrayPropertyType<E> inlineArrayType) {
        return ArrayPropertyBuilder.inlineArrayBuilder(inlineArrayType);
    }

    @NotNull
    public static OptionalProperty<Boolean> optionalBooleanProperty(@NotNull String path) {
        return new OptionalProperty<Boolean>(new BooleanProperty(path, false));
    }

    @NotNull
    public static OptionalProperty<Short> optionalShortProperty(@NotNull String path) {
        return new OptionalProperty<Short>(new ShortProperty(path, 0));
    }

    @NotNull
    public static OptionalProperty<Integer> optionalIntegerProperty(@NotNull String path) {
        return new OptionalProperty<Integer>(new IntegerProperty(path, 0));
    }

    @NotNull
    public static OptionalProperty<Long> optionalLongProperty(@NotNull String path) {
        return new OptionalProperty<Long>(new LongProperty(path, 0L));
    }

    @NotNull
    public static OptionalProperty<Float> optionalFloatProperty(@NotNull String path) {
        return new OptionalProperty<Float>(new FloatProperty(path, 0.0f));
    }

    @NotNull
    public static OptionalProperty<Double> optionalDoubleProperty(@NotNull String path) {
        return new OptionalProperty<Double>(new DoubleProperty(path, 0.0));
    }

    @NotNull
    public static OptionalProperty<String> optionalStringProperty(@NotNull String path) {
        return new OptionalProperty<String>(new StringProperty(path, ""));
    }

    @NotNull
    public static <E extends Enum<E>> OptionalProperty<E> optionalEnumProperty(@NotNull Class<E> clazz, @NotNull String path) {
        return new OptionalProperty<Enum>(new EnumProperty<Enum>(path, clazz, ((Enum[])clazz.getEnumConstants())[0]));
    }

    @NotNull
    public static OptionalProperty<Pattern> optionalRegexProperty(@NotNull String path) {
        return new OptionalProperty<Pattern>(new RegexProperty(path, ""));
    }

    @NotNull
    public static OptionalProperty<List<String>> optionalListProperty(@NotNull String path) {
        return new OptionalProperty<List<String>>(new StringListProperty(path, new String[0]));
    }

    @NotNull
    public static OptionalProperty<Set<String>> optionalSetProperty(@NotNull String path) {
        return new OptionalProperty<Set<String>>(new StringSetProperty(path, new String[0]));
    }
}

