/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.commands;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.gkitz.KitsMenu;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.objects.CEPlayer;
import com.badbones69.crazyenchantments.paper.api.objects.gkitz.GKitz;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import java.util.HashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class GkitzCommand
implements CommandExecutor {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String commandLabel, String[] args) {
        Player player;
        boolean isPlayer = sender instanceof Player;
        if (!this.crazyManager.isGkitzEnabled()) return false;
        if (args.length == 0) {
            if (!isPlayer) {
                sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                return true;
            }
            Player player2 = (Player)sender;
            if (this.crazyManager.getCEPlayer(player2) == null) {
                this.crazyManager.loadCEPlayer(player2);
            }
            if (!this.hasPermission(sender, "gkitz")) return true;
            FileConfiguration gkitz = FileManager.Files.GKITZ.getFile();
            player2.openInventory(new KitsMenu(player2, gkitz.getInt("Settings.GUI-Size"), gkitz.getString("Settings.Inventory-Name")).build().getInventory());
            return true;
        }
        if (args[0].equalsIgnoreCase("reset")) {
            Player player3;
            if (!this.hasPermission(sender, "reset")) return true;
            if (args.length < 2) {
                sender.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&c/GKitz Reset <Kit> [Player]"));
                return true;
            }
            GKitz kit = this.crazyManager.getGKitFromName(args[1]);
            if (kit == null) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("%Kit%", args[1]);
                placeholders.put("%Gkit%", args[1]);
                sender.sendMessage(Messages.NOT_A_GKIT.getMessage(placeholders));
                return true;
            }
            if (args.length >= 3) {
                if (!this.methods.isPlayerOnline(args[2], sender)) {
                    return true;
                }
                player3 = this.methods.getPlayer(args[2]);
            } else {
                if (!isPlayer) {
                    sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                    return true;
                }
                player3 = (Player)sender;
            }
            this.crazyManager.getCEPlayer(player3).removeCoolDown(kit);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%Player%", player3.getName());
            placeholders.put("%Gkit%", kit.getName());
            placeholders.put("%Kit%", kit.getName());
            sender.sendMessage(Messages.RESET_GKIT.getMessage(placeholders));
            return true;
        }
        if (!this.hasPermission(sender, "gkitz")) return true;
        boolean adminGive = false;
        GKitz kit = this.crazyManager.getGKitFromName(args[0]);
        if (kit == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%Kit%", args[0]);
            placeholders.put("%Gkit%", args[0]);
            sender.sendMessage(Messages.NOT_A_GKIT.getMessage(placeholders));
            return true;
        }
        if (args.length >= 2) {
            if (!this.methods.isPlayerOnline(args[1], sender)) {
                return true;
            }
            if (!this.hasPermission(sender, "crazyenchantments.gkitz.give")) return true;
            player = this.methods.getPlayer(args[1]);
            adminGive = true;
        } else {
            if (!isPlayer) {
                sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                return true;
            }
            player = (Player)sender;
        }
        CEPlayer cePlayer = this.crazyManager.getCEPlayer(player);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%Player%", player.getName());
        placeholders.put("%Gkit%", kit.getName());
        placeholders.put("%Kit%", kit.getName());
        if (!cePlayer.hasGkitPermission(kit) && !adminGive) {
            sender.sendMessage(Messages.NO_GKIT_PERMISSION.getMessage(placeholders));
            return true;
        }
        if (!cePlayer.canUseGKit(kit) && !adminGive) {
            sender.sendMessage(ColorUtils.getPrefix() + cePlayer.getCoolDown(kit).getCoolDownLeft(Messages.STILL_IN_COOLDOWN.getMessage(placeholders)));
            return true;
        }
        cePlayer.giveGKit(kit);
        player.sendMessage(Messages.RECEIVED_GKIT.getMessage(placeholders));
        if (adminGive) {
            sender.sendMessage(Messages.GIVEN_GKIT.getMessage(placeholders));
            return true;
        }
        cePlayer.addCoolDown(kit);
        return true;
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        return this.methods.hasPermission(sender, permission, true);
    }
}

