/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.listeners;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.events.AuraActiveEvent;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class AuraListener
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private final CEnchantments[] AURA_ENCHANTMENTS = new CEnchantments[]{CEnchantments.BLIZZARD, CEnchantments.ACIDRAIN, CEnchantments.SANDSTORM, CEnchantments.RADIANT, CEnchantments.INTIMIDATE};

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMoveEvent(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        List<Player> players = this.getNearbyPlayers(player);
        if (players.isEmpty()) {
            return;
        }
        EntityEquipment playerEquipment = player.getEquipment();
        for (ItemStack item : playerEquipment.getArmorContents()) {
            Map<CEnchantment, Integer> itemEnchantments = this.enchantmentBookSettings.getEnchantments(item);
            itemEnchantments.forEach((enchantment, level) -> {
                CEnchantments enchantmentEnum = this.getAuraEnchantmentEnum((CEnchantment)enchantment);
                if (enchantmentEnum != null) {
                    players.forEach(other -> this.plugin.getServer().getPluginManager().callEvent((Event)new AuraActiveEvent(player, (Player)other, enchantmentEnum, (int)level)));
                }
            });
        }
        for (Player other : players) {
            EntityEquipment otherEquipment = other.getEquipment();
            for (ItemStack item : otherEquipment.getArmorContents()) {
                Map<CEnchantment, Integer> itemEnchantments = this.enchantmentBookSettings.getEnchantments(item);
                itemEnchantments.forEach((enchantment, level) -> {
                    CEnchantments enchantmentEnum = this.getAuraEnchantmentEnum((CEnchantment)enchantment);
                    if (enchantmentEnum != null) {
                        this.plugin.getServer().getPluginManager().callEvent((Event)new AuraActiveEvent(other, player, enchantmentEnum, (int)level));
                    }
                });
            }
        }
    }

    private CEnchantments getAuraEnchantmentEnum(CEnchantment enchantment) {
        return Arrays.stream(this.AURA_ENCHANTMENTS).filter(enchantmentEnum -> enchantmentEnum.getName().equals(enchantment.getName())).findFirst().orElse(null);
    }

    private List<Player> getNearbyPlayers(Player player) {
        return player.getNearbyEntities(3.0, 3.0, 3.0).stream().filter(entity -> entity instanceof Player && !entity.getUniqueId().equals(player.getUniqueId())).map(entity -> (Player)entity).collect(Collectors.toList());
    }
}

