/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.listeners;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.enums.Dust;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DustData;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.EnchantedBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class DustControlListener
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();

    private void setBookLore(ItemStack item, int percent, String rate, CEnchantment enchantment, EnchantedBook data) {
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        if (rate.equalsIgnoreCase("Success")) {
            data.setSuccessChance(percent);
        } else {
            data.setDestroyChance(percent);
        }
        for (String line : FileManager.Files.CONFIG.getFile().getStringList("Settings.EnchantmentBookLore")) {
            if (line.toLowerCase().contains("%description%")) {
                enchantment.getInfoDescription().forEach(lines -> lore.add(ColorUtils.legacyTranslateColourCodes(lines)));
                continue;
            }
            TextComponent lineToAdd = ColorUtils.legacyTranslateColourCodes(line.replaceAll("(%Success_Rate%|%success_rate%)", String.valueOf(data.getSuccessChance())).replaceAll("(%Destroy_Rate%|%destroy_rate%)", String.valueOf(data.getDestroyChance())));
            lore.add(lineToAdd);
        }
        item.editPersistentDataContainer(container -> container.set(DataKeys.stored_enchantments.getNamespacedKey(), PersistentDataType.STRING, (Object)Methods.getGson().toJson(data)));
        item.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(lore).build()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        ItemStack book = event.getCurrentItem();
        ItemStack dust = event.getCursor();
        if (book.getAmount() > 1) {
            return;
        }
        PersistentDataContainerView container = dust.getPersistentDataContainer();
        DustData dustData = Methods.getGson().fromJson((String)container.get(DataKeys.dust.getNamespacedKey(), PersistentDataType.STRING), DustData.class);
        EnchantedBook bookData = Methods.getGson().fromJson((String)container.get(DataKeys.stored_enchantments.getNamespacedKey(), PersistentDataType.STRING), EnchantedBook.class);
        if (bookData == null || dustData == null) {
            return;
        }
        boolean toggle = false;
        CEnchantment enchantment = null;
        for (CEnchantment en : this.crazyManager.getRegisteredEnchantments()) {
            if (!en.getName().equalsIgnoreCase(bookData.getName())) continue;
            enchantment = en;
            toggle = true;
            break;
        }
        if (!toggle) {
            return;
        }
        if (dustData.getConfigName().equalsIgnoreCase(Dust.SUCCESS_DUST.getConfigName())) {
            int per = dustData.getChance();
            if (this.methods.hasArgument("%success_rate%", config.getStringList("Settings.EnchantmentBookLore"))) {
                int total = bookData.getSuccessChance();
                if (total >= 100) {
                    return;
                }
                if (player.getGameMode() == GameMode.CREATIVE && dust.getAmount() > 1) {
                    player.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&cPlease unstack the dust for them to work."));
                    return;
                }
                if ((per += total) < 0) {
                    per = 0;
                }
                if (per > 100) {
                    per = 100;
                }
                event.setCancelled(true);
                this.setBookLore(book, per, "Success", enchantment, bookData);
                player.setItemOnCursor(this.methods.removeItem(dust));
            }
            return;
        }
        if (dustData.getConfigName().equalsIgnoreCase(Dust.DESTROY_DUST.getConfigName())) {
            int per = dustData.getChance();
            if (this.methods.hasArgument("%destroy_rate%", config.getStringList("Settings.EnchantmentBookLore"))) {
                int total = bookData.getDestroyChance();
                if (total <= 0) {
                    return;
                }
                if (player.getGameMode() == GameMode.CREATIVE && dust.getAmount() > 1) {
                    player.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&cPlease unstack the dust for them to work."));
                    return;
                }
                if ((per = total - per) < 0) {
                    per = 0;
                }
                if (per > 100) {
                    per = 100;
                }
                event.setCancelled(true);
                this.setBookLore(book, per, "Destroy", enchantment, bookData);
                player.setItemOnCursor(this.methods.removeItem(dust));
            }
        }
    }

    @EventHandler
    public void openDust(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.openAnyHandDust(player, event, true)) {
            return;
        }
        this.openAnyHandDust(player, event, false);
    }

    private boolean openAnyHandDust(Player player, PlayerInteractEvent event, boolean mainHand) {
        ItemStack item;
        PlayerInventory inventory = player.getInventory();
        ItemStack itemStack = item = mainHand ? inventory.getItemInMainHand() : inventory.getItemInOffHand();
        if (item.isEmpty()) {
            return false;
        }
        DustData data = Methods.getGson().fromJson((String)item.getPersistentDataContainer().get(DataKeys.dust.getNamespacedKey(), PersistentDataType.STRING), DustData.class);
        if (data == null) {
            return false;
        }
        if (data.getConfigName().equals(Dust.SUCCESS_DUST.getConfigName())) {
            event.setCancelled(true);
        } else if (data.getConfigName().equals(Dust.DESTROY_DUST.getConfigName())) {
            event.setCancelled(true);
        } else if (data.getConfigName().equals(Dust.MYSTERY_DUST.getConfigName())) {
            event.setCancelled(true);
            if (this.methods.isInventoryFull(player)) {
                player.sendMessage(Messages.INVENTORY_FULL.getMessage());
                return true;
            }
            if (mainHand) {
                inventory.setItemInMainHand(this.methods.removeItem(item));
            } else {
                inventory.setItemInOffHand(this.methods.removeItem(item));
            }
            ItemStack item2 = this.pickDust().getDust(this.methods.percentPick(data.getChance() + 1, 1), 1);
            inventory.addItem(new ItemStack[]{item2});
            player.playSound(player.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
            FileConfiguration config = FileManager.Files.CONFIG.getFile();
            if (config.getBoolean("Settings.Dust.MysteryDust.Firework.Toggle")) {
                ArrayList<Color> colors = new ArrayList<Color>();
                ColorUtils.color(colors, config.getString("Settings.Dust.MysteryDust.Firework.Colors", "Black, Gray, Lime"));
                this.methods.fireWork(player.getLocation().add(0.0, 1.0, 0.0), (List<Color>)colors);
            }
        }
        return true;
    }

    private Dust pickDust() {
        ArrayList<Dust> dusts = new ArrayList<Dust>();
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        if (config.getBoolean("Settings.Dust.MysteryDust.Dust-Toggle.Success")) {
            dusts.add(Dust.SUCCESS_DUST);
        }
        if (config.getBoolean("Settings.Dust.MysteryDust.Dust-Toggle.Destroy")) {
            dusts.add(Dust.DESTROY_DUST);
        }
        if (config.getBoolean("Settings.Dust.MysteryDust.Dust-Toggle.Failed")) {
            dusts.add(Dust.FAILED_DUST);
        }
        return (Dust)((Object)dusts.get(new Random().nextInt(dusts.size())));
    }
}

