/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.builders.types;

import com.ryderbelserion.fusion.paper.builders.BaseItemBuilder;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerBuilder
extends BaseItemBuilder<SpawnerBuilder> {
    private EntityType entityType;
    private int count = 0;
    private int delay = -1;
    private int range = 0;

    public SpawnerBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    public SpawnerBuilder withEntityType(@Nullable EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @NotNull
    public SpawnerBuilder withSpawnCount(int count) {
        this.count = count;
        return this;
    }

    @NotNull
    public SpawnerBuilder withSpawnDelay(int delay) {
        this.delay = delay;
        return this;
    }

    @NotNull
    public SpawnerBuilder withSpawnRange(int range) {
        this.range = range;
        return this;
    }

    @Override
    public SpawnerBuilder build() {
        if (this.entityType == null) {
            return this;
        }
        this.itemStack.editMeta(itemMeta -> {
            if (!(itemMeta instanceof BlockStateMeta)) {
                return;
            }
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            if (!(blockStateMeta instanceof CreatureSpawner)) {
                return;
            }
            CreatureSpawner spawner = (CreatureSpawner)blockStateMeta;
            if (this.count > 0) {
                spawner.setSpawnCount(this.count);
            }
            if (this.delay > 0) {
                spawner.setDelay(this.delay);
            }
            if (this.range > 0) {
                spawner.setSpawnRange(this.range);
            }
            spawner.setSpawnedType(this.entityType);
            blockStateMeta.setBlockState((BlockState)spawner);
        });
        return this;
    }
}

