/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.ryderbelserion.fusion.paper.FusionPaper;
import java.io.File;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MigrateManager {
    @NotNull
    private static final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private static final FusionPaper fusion = plugin.getFusion();

    public static void convert() {
        YamlConfiguration secondConfiguration;
        ConfigurationSection settings;
        double tinkerVersion = 1.1;
        File firstFile = new File(String.valueOf(plugin.getDataFolder()) + "/Tinker.yml");
        File secondFile = new File(String.valueOf(plugin.getDataFolder()) + "/Tinker-v1.yml");
        FileConfiguration TINKER = FileManager.Files.TINKER.getFile();
        if (TINKER.getDouble("Settings.Tinker-Version") >= tinkerVersion) {
            plugin.getLogger().info("Tinker.yml is up to date.");
            return;
        }
        plugin.getLogger().warning("Updating Tinker.yml version.");
        TINKER.set("Settings.Tinker-Version", (Object)tinkerVersion);
        FileManager.Files.TINKER.saveFile();
        if (firstFile.renameTo(secondFile)) {
            plugin.getLogger().warning("Renamed " + firstFile.getName() + " to Tinker-v1.yml");
            FileManager.Files.TINKER.saveFile();
        }
        if ((settings = (secondConfiguration = YamlConfiguration.loadConfiguration((File)secondFile)).getConfigurationSection("Settings")) == null) {
            fusion.log("warn", "The black-smith section cannot be found in config.yml, It's possible the file is badly formatted!", new Object[0]);
        } else {
            for (Object setting : settings.getKeys(false)) {
                TINKER.set("Settings." + (String)setting, secondConfiguration.get("Settings." + (String)setting));
            }
        }
        ConfigurationSection enchantments = secondConfiguration.getConfigurationSection("Tinker.Vanilla-Enchantments");
        if (enchantments == null) {
            fusion.log("warn", "The black-smith section cannot be found in config.yml, It's possible the file is badly formatted!", new Object[0]);
        } else {
            for (String enchantment : enchantments.getKeys(false)) {
                int amount = secondConfiguration.getInt("Tinker.Vanilla-Enchantments." + enchantment);
                TINKER.set("Tinker.Vanilla-Enchantments." + enchantment, (Object)(amount + ", 1"));
            }
        }
        ConfigurationSection custom = secondConfiguration.getConfigurationSection("Tinker.Crazy-Enchantments");
        if (custom == null) {
            fusion.log("warn", "The black-smith section cannot be found in config.yml, It's possible the file is badly formatted!", new Object[0]);
        } else {
            for (String enchantment : custom.getKeys(false)) {
                ConfigurationSection type = secondConfiguration.getConfigurationSection("Tinker.Crazy-Enchantments." + enchantment);
                if (type == null) {
                    fusion.log("warn", "The enchantment {} could not be found in the tinker.yml", enchantment);
                    continue;
                }
                for (String itemBook : type.getKeys(false)) {
                    int value = secondConfiguration.getInt("Tinker.Crazy-Enchantments." + enchantment + "." + itemBook);
                    TINKER.set("Tinker.Crazy-Enchantments." + enchantment + "." + itemBook, (Object)(value + ", 1"));
                }
            }
        }
        FileManager.Files.TINKER.saveFile();
        plugin.getLogger().warning("Tinker.yml file has been updated.");
    }
}

