/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.builders.types.blacksmith;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.ryderbelserion.fusion.paper.FusionPaper;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class BlackSmithManager {
    private static final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private static final FusionPaper fusion = plugin.getFusion();
    private static ItemStack exitButton;
    private static ItemStack redGlass;
    private static ItemStack blueGlass;
    private static ItemStack grayGlass;
    private static String inventoryName;
    private static String itemCost;
    private static Currency currency;
    private static int bookUpgrade;
    private static int levelUp;
    private static int addEnchantment;
    private static boolean maxEnchantments;

    public static void load() {
        redGlass = new ItemBuilder().setMaterial(Material.RED_STAINED_GLASS_PANE).setName(" ").build();
        grayGlass = new ItemBuilder().setMaterial(Material.GRAY_STAINED_GLASS_PANE).setName(" ").build();
        blueGlass = new ItemBuilder().setMaterial(Material.LIGHT_BLUE_STAINED_GLASS_PANE).setName(" ").build();
        BlackSmithManager.get(FileManager.Files.CONFIG.getFile());
    }

    public static void refresh() {
        BlackSmithManager.get(FileManager.Files.CONFIG.getFile());
    }

    public static ItemStack getExitButton() {
        return exitButton;
    }

    public static ItemStack getBlueGlass() {
        return blueGlass;
    }

    public static ItemStack getGrayGlass() {
        return grayGlass;
    }

    public static ItemStack getRedGlass() {
        return redGlass;
    }

    public static Currency getCurrency() {
        return currency;
    }

    public static int getAddEnchantment() {
        return addEnchantment;
    }

    public static int getBookUpgrade() {
        return bookUpgrade;
    }

    public static int getLevelUp() {
        return levelUp;
    }

    public static String getInventoryName() {
        return inventoryName;
    }

    public static String getItemCost() {
        return itemCost;
    }

    public static boolean isMaxEnchantments() {
        return maxEnchantments;
    }

    private static ConfigurationSection getSection(FileConfiguration config) {
        return config.getConfigurationSection("Settings.BlackSmith");
    }

    private static void get(FileConfiguration config) {
        ConfigurationSection section = BlackSmithManager.getSection(config);
        if (section == null) {
            fusion.log("warn", "The black-smith section cannot be found in config.yml, It's possible the file is badly formatted!", new Object[0]);
            return;
        }
        exitButton = new ItemBuilder().setMaterial(Material.BARRIER).setName(section.getString("Results.None", "&c&lNo Results.")).setLore(section.getStringList("Results.Not-Found-Lore")).build();
        inventoryName = ColorUtils.color(section.getString("GUIName"));
        itemCost = section.getString("Results.Found", "&c&lCost: &6&l%cost% XP");
        currency = Currency.getCurrency(section.getString("Transaction.Currency", "XP_LEVEL"));
        bookUpgrade = section.getInt("Transaction.Costs.Book-Upgrade", 5);
        levelUp = section.getInt("Transaction.Costs.Power-Up", 5);
        addEnchantment = section.getInt("Transaction.Costs.Add-Enchantment", 3);
        maxEnchantments = config.getBoolean("Settings.EnchantmentOptions.MaxAmountOfEnchantmentsToggle", true);
    }
}

