/*
 * Decompiled with CFR 0.152.
 */
package net.nebula.highlighted_friends;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class CommandRegistration {
    public static HashMap<String, UUID> players = new HashMap();
    static class_310 client = class_310.method_1551();

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"highlighted-friends").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            players.put(name, null);
            if (CommandRegistration.client.field_1724 != null) {
                CommandRegistration.client.field_1724.method_7353(class_2561.method_30163((String)("Added " + name)), false);
            }
            new Thread(() -> CommandRegistration.updatePlayersUUIDsAndNames(false)).start();
            return 1;
        })))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String input = StringArgumentType.getString((CommandContext)context, (String)"name").toLowerCase();
            players.keySet().stream().filter(k -> k.toLowerCase().equals(input)).findFirst().ifPresent(players::remove);
            if (CommandRegistration.client.field_1724 != null) {
                CommandRegistration.client.field_1724.method_7353(class_2561.method_30163((String)("Removed " + input)), false);
            }
            new Thread(() -> CommandRegistration.updatePlayersUUIDsAndNames(false)).start();
            return 1;
        })))).then(ClientCommandManager.literal((String)"list").executes(context -> {
            new Thread(() -> {
                CommandRegistration.updatePlayersUUIDsAndNames(true);
                CommandRegistration.sendPlayerListMessage();
            }).start();
            return 1;
        }))));
    }

    private static void updatePlayersUUIDsAndNames(boolean message) {
        HttpClient httpClient = HttpClient.newHttpClient();
        Gson gson = new Gson();
        if (message && CommandRegistration.client.field_1724 != null && !players.isEmpty()) {
            CommandRegistration.client.field_1724.method_7353(class_2561.method_30163((String)"Loading..."), false);
        }
        HashMap<String, UUID> updatedPlayers = new HashMap<String, UUID>(players);
        for (Map.Entry<String, UUID> entry : updatedPlayers.entrySet()) {
            String nameKey = entry.getKey();
            UUID uuid = entry.getValue();
            try {
                if (uuid == null) {
                    HttpRequest reqUuid = HttpRequest.newBuilder().uri(URI.create("https://api.mojang.com/users/profiles/minecraft/" + nameKey)).build();
                    HttpResponse<String> respUuid = httpClient.send(reqUuid, HttpResponse.BodyHandlers.ofString());
                    if (respUuid.statusCode() == 200) {
                        JsonObject json = (JsonObject)gson.fromJson(respUuid.body(), JsonObject.class);
                        String rawId = json.get("id").getAsString();
                        uuid = UUID.fromString(rawId.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
                        players.put(nameKey, uuid);
                    } else {
                        System.out.println("UUID not found for username: " + nameKey);
                        continue;
                    }
                }
                String uuidStr = uuid.toString().replace("-", "");
                HttpRequest reqName = HttpRequest.newBuilder().uri(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuidStr)).build();
                HttpResponse<String> respName = httpClient.send(reqName, HttpResponse.BodyHandlers.ofString());
                if (respName.statusCode() == 200) {
                    JsonObject json = (JsonObject)gson.fromJson(respName.body(), JsonObject.class);
                    String currentName = json.get("name").getAsString();
                    if (nameKey.equals(currentName)) continue;
                    players.remove(nameKey);
                    players.put(currentName, uuid);
                    System.out.println("Renamed: " + nameKey + " -> " + currentName);
                    continue;
                }
                System.out.println("Failed to get name for UUID: " + String.valueOf(uuid));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CommandRegistration.saveConfig();
    }

    private static void sendPlayerListMessage() {
        if (CommandRegistration.client.field_1724 == null) {
            return;
        }
        String message = String.join((CharSequence)", ", players.keySet());
        if (!message.isEmpty()) {
            CommandRegistration.client.field_1724.method_7353(class_2561.method_30163((String)message), false);
        } else {
            CommandRegistration.client.field_1724.method_7353(class_2561.method_30163((String)"No players found"), false);
        }
    }

    public static void saveConfig() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            File file = new File("config/highlighted_friends.json");
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            gson.toJson(players, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() {
        try {
            Gson gson = new Gson();
            File file = new File("config/highlighted_friends.json");
            if (!file.exists()) {
                return;
            }
            FileReader reader = new FileReader(file);
            Type type = new TypeToken<HashMap<String, UUID>>(){}.getType();
            players = (HashMap)gson.fromJson((Reader)reader, type);
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

