/*
 * Decompiled with CFR 0.152.
 */
package io.github.poeticrainbow.smoothtexturefix;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import io.github.poeticrainbow.smoothtexturefix.SmoothTextureFix;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class ModConfig {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private boolean overrideTextureFilter;

    public ModConfig(boolean overrideTextureFiltering) {
        this.overrideTextureFilter = overrideTextureFiltering;
    }

    public static ModConfig loadConfig(Path path) {
        File configFile = path.toFile();
        if (configFile.exists() && configFile.isFile()) {
            ModConfig modConfig;
            block9: {
                BufferedReader reader = Files.newBufferedReader(path);
                try {
                    modConfig = (ModConfig)gson.fromJson((Reader)reader, ModConfig.class);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonParseException | IOException throwable3) {
                        // empty catch block
                    }
                }
                reader.close();
            }
            return modConfig;
        }
        return new ModConfig(true);
    }

    public void saveConfig(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            SmoothTextureFix.LOGGER.warn("Could not save config file");
        }
    }

    public boolean overrideTextureFilter() {
        return this.overrideTextureFilter;
    }

    public void overrideTextureFilter(boolean value) {
        this.overrideTextureFilter = value;
    }
}

