/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.client.compat.controlify;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import io.github.mattidragon.nodeflow.NodeFlow;
import io.github.mattidragon.nodeflow.client.compat.controlify.ControlifyProxy;
import io.github.mattidragon.nodeflow.client.ui.screen.EditorScreen;
import io.github.mattidragon.nodeflow.client.ui.screen.HandledEditorScreen;
import io.github.mattidragon.nodeflow.client.ui.widget.EditorAreaWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ControlifyPlugin
implements ControlifyProxy {
    private static final class_2561 NODEFLOW_CATEGORY = class_2561.method_43471((String)"key.categories.nodeflow");
    private InputBindingSupplier editorUpKey;
    private InputBindingSupplier editorDownKey;
    private InputBindingSupplier editorLeftKey;
    private InputBindingSupplier editorRightKey;

    @Override
    public void register() {
        this.registerScreenType(EditorScreen.class);
        this.registerScreenType(HandledEditorScreen.class);
        this.editorUpKey = ControlifyBindApi.get().registerBinding(builder -> builder.defaultInput(GamepadInputs.getBind((class_2960)GamepadInputs.RIGHT_STICK_AXIS_UP)).id(NodeFlow.id("editor_up")).category(NODEFLOW_CATEGORY).allowedContexts(new BindContext[]{BindContext.V_MOUSE_CURSOR}));
        this.editorDownKey = ControlifyBindApi.get().registerBinding(builder -> builder.defaultInput(GamepadInputs.getBind((class_2960)GamepadInputs.RIGHT_STICK_AXIS_DOWN)).id(NodeFlow.id("editor_down")).category(NODEFLOW_CATEGORY).allowedContexts(new BindContext[]{BindContext.V_MOUSE_CURSOR}));
        this.editorLeftKey = ControlifyBindApi.get().registerBinding(builder -> builder.defaultInput(GamepadInputs.getBind((class_2960)GamepadInputs.RIGHT_STICK_AXIS_LEFT)).id(NodeFlow.id("editor_left")).category(NODEFLOW_CATEGORY).allowedContexts(new BindContext[]{BindContext.V_MOUSE_CURSOR}));
        this.editorRightKey = ControlifyBindApi.get().registerBinding(builder -> builder.defaultInput(GamepadInputs.getBind((class_2960)GamepadInputs.RIGHT_STICK_AXIS_RIGHT)).id(NodeFlow.id("editor_right")).category(NODEFLOW_CATEGORY).allowedContexts(new BindContext[]{BindContext.V_MOUSE_CURSOR}));
    }

    @Override
    public void registerScreenType(Class<? extends EditorScreen> clazz) {
        ScreenProcessorProvider.registerProvider(clazz, x$0 -> new EditorScreenProcessor((EditorScreen)((Object)x$0)));
    }

    @Environment(value=EnvType.CLIENT)
    private class EditorScreenProcessor
    extends ScreenProcessor<EditorScreen> {
        public EditorScreenProcessor(EditorScreen screen) {
            super((class_437)screen);
        }

        public void onWidgetRebuild() {
            super.onWidgetRebuild();
            ButtonGuidePredicate predicate = button -> !Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled();
            ButtonGuideApi.addGuideToButton((Object)((EditorScreen)this.screen).plusButton, (InputBindingSupplier)ControlifyBindings.GUI_ABSTRACT_ACTION_1, (ButtonGuidePredicate)predicate);
            ButtonGuideApi.addGuideToButton((Object)((EditorScreen)this.screen).deleteButton, (InputBindingSupplier)ControlifyBindings.GUI_ABSTRACT_ACTION_2, (ButtonGuidePredicate)predicate);
            ButtonGuideApi.addGuideToButton((Object)((EditorScreen)this.screen).backButton, (InputBindingSupplier)ControlifyBindings.GUI_BACK, (ButtonGuidePredicate)predicate);
        }

        protected void handleButtons(ControllerEntity controller) {
            if (((EditorScreen)this.screen).plusButton.field_22763 && ControlifyBindings.GUI_ABSTRACT_ACTION_1.on(controller).justPressed()) {
                ((EditorScreen)this.screen).plusButton.method_25306();
            }
            if (((EditorScreen)this.screen).deleteButton.field_22763 && ControlifyBindings.GUI_ABSTRACT_ACTION_2.on(controller).justPressed()) {
                ((EditorScreen)this.screen).deleteButton.method_25306();
            }
            if (ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
                if (((EditorScreen)this.screen).backButton.field_22763) {
                    ((EditorScreen)this.screen).backButton.method_25306();
                } else {
                    ((EditorScreen)this.screen).method_25419();
                }
            }
            if (ControlifyBindings.GUI_PRESS.on(controller).justPressed()) {
                ((EditorScreen)this.screen).method_25404(257, 0, 0);
            }
            EditorAreaWidget area = ((EditorScreen)this.screen).getArea();
            float impulseX = ControlifyPlugin.this.editorRightKey.on(controller).analogueNow() - ControlifyPlugin.this.editorLeftKey.on(controller).analogueNow();
            float impulseY = ControlifyPlugin.this.editorDownKey.on(controller).analogueNow() - ControlifyPlugin.this.editorUpKey.on(controller).analogueNow();
            area.setViewX(area.getViewX() + (double)(impulseX * class_3532.method_15379((float)impulseX) * -10.0f));
            area.setViewY(area.getViewY() + (double)(impulseY * class_3532.method_15379((float)impulseY) * -10.0f));
        }

        protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
            EditorAreaWidget area = ((EditorScreen)this.screen).getArea();
            float impulseX = ControlifyPlugin.this.editorRightKey.on(controller).analogueNow() - ControlifyPlugin.this.editorLeftKey.on(controller).analogueNow();
            float impulseY = ControlifyPlugin.this.editorDownKey.on(controller).analogueNow() - ControlifyPlugin.this.editorUpKey.on(controller).analogueNow();
            area.setViewX(area.getViewX() + (double)(impulseX * class_3532.method_15379((float)impulseX) * -10.0f));
            area.setViewY(area.getViewY() + (double)(impulseY * class_3532.method_15379((float)impulseY) * -10.0f));
        }
    }
}

