/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.client.ui;

import io.github.mattidragon.nodeflow.client.ui.node.NumberNodeConfigScreen;
import io.github.mattidragon.nodeflow.client.ui.node.TypedNodeConfigScreen;
import io.github.mattidragon.nodeflow.client.ui.screen.EditorScreen;
import io.github.mattidragon.nodeflow.client.ui.screen.NodeConfigScreen;
import io.github.mattidragon.nodeflow.graph.node.Node;
import io.github.mattidragon.nodeflow.graph.node.NodeType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class NodeConfigScreenRegistry {
    private static final Map<NodeType<?>, Factory<?>> FACTORIES = new HashMap();

    public static void registerDefaults() {
        NodeConfigScreenRegistry.register(NumberNodeConfigScreen::new, NodeType.NUMBER);
        NodeConfigScreenRegistry.register(TypedNodeConfigScreen::new, NodeType.SWITCH);
    }

    @SafeVarargs
    public static <T extends Node> void register(Factory<T> factory, NodeType<? extends T> ... types) {
        for (NodeType<? extends T> type : types) {
            FACTORIES.put(type, factory);
        }
    }

    public static boolean hasConfig(Node node) {
        return FACTORIES.containsKey(node.type);
    }

    public static <T extends Node> NodeConfigScreen<T> createScreen(T node, EditorScreen parent) {
        return (NodeConfigScreen)((Object)NodeConfigScreenRegistry.unsafeCast(FACTORIES.get(node.type).apply((Node)NodeConfigScreenRegistry.unsafeCast(node), parent)));
    }

    private static <T> T unsafeCast(Object object) {
        return (T)object;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Factory<T extends Node>
    extends BiFunction<T, EditorScreen, NodeConfigScreen<T>> {
        @Override
        public NodeConfigScreen<T> apply(T var1, EditorScreen var2);
    }
}

