/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.client.ui.screen;

import io.github.mattidragon.nodeflow.NodeFlow;
import io.github.mattidragon.nodeflow.client.ui.MessageToast;
import io.github.mattidragon.nodeflow.client.ui.widget.EditorAreaWidget;
import io.github.mattidragon.nodeflow.client.ui.widget.NodeWidget;
import io.github.mattidragon.nodeflow.graph.Connector;
import io.github.mattidragon.nodeflow.graph.Graph;
import io.github.mattidragon.nodeflow.graph.node.Node;
import io.github.mattidragon.nodeflow.graph.node.NodeType;
import io.github.mattidragon.nodeflow.graph.node.group.NodeGroup;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6880;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EditorScreen
extends class_437 {
    private static final class_2960 DEFAULT_TEXTURE = NodeFlow.id("textures/gui/editor.png");
    public static final int TILE_SIZE = 16;
    public static final int BORDER_SIZE = 8;
    public static final int BORDER_OFFSET = 32;
    public static final int GRID_OFFSET = 40;
    public final Graph graph;
    public final class_2960 texture;
    protected boolean isAddingNode = false;
    protected boolean isDeletingNode = false;
    @Nullable
    protected Connector<?> lastHoveredConnector = null;
    protected long lastHoveredTimestamp = 0L;
    @Nullable
    public Connector<?> connectingConnector;
    public class_4185 backButton;
    protected final Map<NodeGroup, List<class_4185>> nodeButtons = new HashMap<NodeGroup, List<class_4185>>();
    protected final List<class_4185> groupButtons = new ArrayList<class_4185>();
    @Nullable
    protected NodeGroup activeGroup = null;
    public class_4185 plusButton;
    public class_4185 deleteButton;
    private AddNodesWidget addMenu;
    protected EditorAreaWidget area;

    public EditorScreen(class_2561 title, Graph graph) {
        this(title, graph, DEFAULT_TEXTURE);
    }

    public EditorScreen(class_2561 title, Graph graph, class_2960 texture) {
        super(title);
        this.graph = graph;
        this.texture = texture;
        for (NodeGroup group : graph.env.groups()) {
            this.addGroup(graph, group);
        }
    }

    public <T extends class_364 & class_4068> T method_37063(T drawableElement) {
        return (T)super.method_37063(drawableElement);
    }

    private void addGroup(Graph graph, NodeGroup group) {
        this.groupButtons.add(class_4185.method_46430((class_2561)group.getName(), button -> {
            this.activeGroup = group;
            this.updateAddButtons();
            this.updateVisibility();
        }).method_46434(0, 0, 100, 20).method_46431());
        ArrayList<class_4185> buttons = new ArrayList<class_4185>();
        for (NodeType<?> type : group.getTypes()) {
            buttons.add(class_4185.method_46430((class_2561)type.name(), button1 -> {
                this.toggleAddingMode();
                Node node = (Node)type.generator().apply(graph);
                node.guiX = (int)this.area.modifyX((double)this.field_22789 / 2.0);
                node.guiY = (int)this.area.modifyY((double)this.field_22790 / 2.0);
                graph.addNode(node);
                NodeWidget widget = new NodeWidget(node, this);
                this.area.add(widget);
                this.syncGraph();
            }).method_46434(0, 0, 100, 20).method_46431());
        }
        this.nodeButtons.put(group, buttons);
    }

    protected void method_25426() {
        this.area = this.method_37063(new EditorAreaWidget(40, 40, this.getBoxWidth(), this.getBoxHeight(), this));
        this.area.method_25396().clear();
        for (Node node : this.graph.getNodes()) {
            NodeWidget widget = new NodeWidget(node, this);
            this.area.add(widget);
        }
        this.plusButton = this.method_37063(class_4185.method_46430((class_2561)class_2561.method_43473(), button -> this.toggleAddingMode()).method_46434(40, 12, 100, 20).method_46431());
        this.deleteButton = this.method_37063(class_4185.method_46430((class_2561)class_2561.method_43473(), button1 -> this.toggleDeletingMode()).method_46434(150, 12, 100, 20).method_46431());
        this.backButton = this.method_37063(class_4185.method_46430((class_2561)class_5244.field_24339, button -> {
            this.activeGroup = null;
            this.updateAddButtons();
            this.updateVisibility();
        }).method_46434(150, 12, 100, 20).method_46431());
        this.addMenu = this.method_37063(new AddNodesWidget(this.field_22787, this.getBoxWidth(), this.getBoxHeight() - 10, 50));
        this.updateAddButtons();
        this.updateVisibility();
    }

    private void updateAddButtons() {
        List<class_4185> buttons = this.activeGroup == null ? this.groupButtons : this.nodeButtons.get(this.activeGroup);
        ArrayList<AddNodesWidget.Entry> entries = new ArrayList<AddNodesWidget.Entry>();
        ArrayList<Object> currentButtons = new ArrayList<class_4185>();
        for (class_4185 button : buttons) {
            currentButtons.add(button);
            if (currentButtons.size() < this.addMenu.getButtonCount()) continue;
            entries.add(new AddNodesWidget.Entry(currentButtons));
            currentButtons = new ArrayList();
        }
        if (!currentButtons.isEmpty()) {
            entries.add(new AddNodesWidget.Entry(currentButtons));
        }
        this.addMenu.method_25314(entries);
        this.addMenu.method_44382(0.0);
    }

    public void syncGraph() {
    }

    private void toggleDeletingMode() {
        this.isDeletingNode = !this.isDeletingNode;
        this.updateVisibility();
    }

    private void toggleAddingMode() {
        this.isAddingNode = !this.isAddingNode;
        this.activeGroup = null;
        this.updateAddButtons();
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.area.method_25396().forEach(node -> {
            node.field_22763 = !this.isAddingNode;
        });
        this.backButton.field_22763 = this.isAddingNode && this.activeGroup != null;
        this.backButton.field_22764 = this.isAddingNode && this.activeGroup != null;
        this.addMenu.field_22763 = this.isAddingNode;
        this.addMenu.field_22764 = this.isAddingNode;
        this.deleteButton.field_22763 = !this.isAddingNode;
        this.deleteButton.field_22764 = !this.isAddingNode;
        this.plusButton.field_22763 = !this.isDeletingNode;
        this.plusButton.field_22764 = !this.isDeletingNode;
        this.area.active = !this.isAddingNode;
        this.deleteButton.method_25355((class_2561)(this.isDeletingNode ? class_5244.field_24335 : class_2561.method_43471((String)"nodeflow.editor.button.delete_nodes")));
        this.plusButton.method_25355((class_2561)(this.isAddingNode ? class_5244.field_24335 : class_2561.method_43471((String)"nodeflow.editor.button.add_node")));
    }

    public void removeNode(NodeWidget node) {
        this.graph.removeNode(node.node.id);
        this.area.method_25396().remove((Object)node);
        this.area.remove(node);
        this.syncGraph();
    }

    private void tryFindConnection(double mouseX, double mouseY) {
        Connector<?> row = this.findConnectorAt(mouseX, mouseY);
        if (row == null) {
            return;
        }
        if (this.connectingConnector == null) {
            return;
        }
        if (row.equals(this.connectingConnector)) {
            this.graph.removeConnections(this.connectingConnector);
            return;
        }
        if (this.connectingConnector.isOutput() == row.isOutput()) {
            if (row.isOutput()) {
                this.showToast((class_2561)class_2561.method_43471((String)"nodeflow.editor.toast.two_outputs").method_27692(class_124.field_1061));
            } else {
                this.showToast((class_2561)class_2561.method_43471((String)"nodeflow.editor.toast.two_inputs").method_27692(class_124.field_1061));
            }
            return;
        }
        if (this.connectingConnector.type() != row.type()) {
            this.showToast((class_2561)class_2561.method_43471((String)"nodeflow.editor.toast.different_type").method_27692(class_124.field_1061));
            return;
        }
        if (!row.type().splittable() || !row.isOutput()) {
            this.graph.removeConnections(row);
        }
        this.graph.addConnection(this.connectingConnector, row);
        ArrayDeque stack = new ArrayDeque();
        Connector<?> searchTarget = this.connectingConnector.isOutput() ? this.connectingConnector : row;
        Connector<?> searchStarter = this.connectingConnector.isOutput() ? row : this.connectingConnector;
        Arrays.stream(searchStarter.parent().getOutputs()).map(this.graph::getConnections).flatMap(Collection::stream).map(connection -> connection.getTargetConnector(this.graph)).filter(Objects::nonNull).forEach(stack::push);
        while (!stack.isEmpty()) {
            Connector element = (Connector)stack.pop();
            if (element.equals(searchTarget) || element.equals(searchStarter)) {
                this.showToast((class_2561)class_2561.method_43471((String)"nodeflow.editor.toast.recursion").method_27692(class_124.field_1061));
                this.graph.removeConnections(this.connectingConnector);
                return;
            }
            Arrays.stream(element.parent().getOutputs()).map(this.graph::getConnections).flatMap(Collection::stream).map(connection -> connection.getTargetConnector(this.graph)).filter(Objects::nonNull).forEach(stack::push);
        }
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.connectingConnector != null && button == 0) {
            if (!this.connectingConnector.type().splittable() || !this.connectingConnector.isOutput()) {
                this.graph.removeConnections(this.connectingConnector);
            }
            this.tryFindConnection(mouseX, mouseY);
            this.area.method_25396().forEach(NodeWidget::updateTooltip);
            this.connectingConnector = null;
        }
        this.syncGraph();
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.isAddingNode) {
            this.addMenu.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
            return true;
        }
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        long time;
        if (this.isAddingNode) {
            return;
        }
        Connector<?> connector = this.findConnectorAt(mouseX, mouseY);
        if (connector == null || this.field_22787 == null) {
            return;
        }
        long l = time = this.field_22787.field_1687 == null ? 0L : this.field_22787.field_1687.method_8510();
        if (!connector.equals(this.lastHoveredConnector) || time - this.lastHoveredTimestamp > 10L) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.7f));
        }
        this.lastHoveredConnector = connector;
        this.lastHoveredTimestamp = time;
    }

    public NodeWidget findWidget(Node node) {
        for (NodeWidget widget : this.area.method_25396()) {
            if (widget.node != node) continue;
            return widget;
        }
        return null;
    }

    public NodeWidget.Segment findSegment(Connector<?> connector) {
        for (NodeWidget.Segment segment : this.findWidget(connector.parent()).calculateSegments()) {
            if (!segment.connector.equals(connector)) continue;
            return segment;
        }
        return null;
    }

    @Nullable
    private Connector<?> findConnectorAt(double mouseX, double mouseY) {
        for (NodeWidget node : this.area.method_25396()) {
            for (NodeWidget.Segment segment : node.calculateSegments()) {
                if (!segment.hasConnectorAt(this.area.modifyX(mouseX), this.area.modifyY(mouseY))) continue;
                return segment.connector;
            }
        }
        return null;
    }

    @Nullable
    public NodeWidget.Segment findSegmentAt(double mouseX, double mouseY) {
        for (NodeWidget node : this.area.method_25396()) {
            for (NodeWidget.Segment segment : node.calculateSegments()) {
                if (!segment.hasConnectorAt(this.area.modifyX(mouseX), this.area.modifyY(mouseY))) continue;
                return segment;
            }
        }
        return null;
    }

    public int getBoxWidth() {
        return (this.field_22789 - 80) / 16 * 16;
    }

    public int getBoxHeight() {
        return (this.field_22790 - 80) / 16 * 16;
    }

    public void showToast(class_2561 message) {
        class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(message));
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        super.method_25419();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7346();
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        this.renderArea(context);
    }

    private void renderArea(class_332 context) {
        class_2960 texture = this.area.method_25370() && this.field_22787 != null && this.field_22787.method_48186().method_48183() ? NodeFlow.id("editor_selected") : NodeFlow.id("editor");
        context.method_52706(class_10799.field_56883, texture, 32, 32, this.getBoxWidth() + 16, this.getBoxHeight() + 16);
    }

    public boolean isDeletingNode() {
        return this.isDeletingNode;
    }

    public EditorAreaWidget getArea() {
        return this.area;
    }

    public void method_25395(@Nullable class_364 focused) {
        if (focused == this.method_25399()) {
            return;
        }
        super.method_25395(focused);
    }

    @Environment(value=EnvType.CLIENT)
    private static class AddNodesWidget
    extends class_4265<Entry> {
        public AddNodesWidget(class_310 client, int width, int height, int y) {
            super(client, width, height, y, 30);
            this.field_22744 = true;
            this.method_46421(40);
        }

        public void method_25314(Collection<Entry> newEntries) {
            super.method_25314(newEntries);
        }

        public int addEntry(Entry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        protected void method_57713(class_332 context) {
        }

        protected void method_57715(class_332 context) {
        }

        public int method_25322() {
            return this.getButtonCount() * 110 - 10;
        }

        public int getButtonCount() {
            return (this.field_22758 - 50) / 110;
        }

        protected int method_65507() {
            return this.field_22758 / 2 + this.method_25322() / 2 + 40 + 10;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.field_22763) {
                return false;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        protected void method_25311(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_44379(0, this.method_46427(), this.field_22758 + 40, this.field_22759 + this.method_46427());
            super.method_25311(context, mouseX, mouseY, delta);
            context.method_44380();
        }

        @Nullable
        public class_8016 method_48205(class_8023 navigation) {
            if (!this.field_22763) {
                return null;
            }
            return super.method_48205(navigation);
        }

        @Environment(value=EnvType.CLIENT)
        private static class Entry
        extends class_4265.class_4266<Entry> {
            private final List<class_4185> buttons;

            public Entry(List<class_4185> buttons) {
                this.buttons = buttons;
            }

            public List<? extends class_6379> method_37025() {
                return this.buttons;
            }

            public List<? extends class_364> method_25396() {
                return this.buttons;
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
                for (int i = 0; i < this.buttons.size(); ++i) {
                    class_4185 button = this.buttons.get(i);
                    button.method_46419(y);
                    button.method_46421(x + i * 110);
                    button.method_25394(context, mouseX, mouseY, delta);
                }
            }
        }
    }
}

