/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.client.ui.widget;

import io.github.mattidragon.nodeflow.NodeFlow;
import io.github.mattidragon.nodeflow.client.ui.NodeConfigScreenRegistry;
import io.github.mattidragon.nodeflow.client.ui.widget.EditorAreaWidget;
import io.github.mattidragon.nodeflow.client.ui.widget.NodeWidget;
import io.github.mattidragon.nodeflow.graph.node.NodeTag;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ContextMenuWidget
extends class_362
implements class_4068 {
    private final EditorAreaWidget area;
    public NodeWidget node;
    public final List<class_339> widgets = new ArrayList<class_339>();

    public ContextMenuWidget(EditorAreaWidget area) {
        this.area = area;
    }

    public void show(int x, int y, @Nullable NodeWidget node) {
        this.hide();
        this.widgets.add((class_339)class_4185.method_46430((class_2561)class_5244.field_24335, __ -> this.hide()).method_46437(100, 12).method_46431());
        if (node != null) {
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.duplicate"), __ -> this.area.duplicateNode()).method_46437(100, 12).method_46431());
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.delete"), __ -> this.area.deleteNode()).method_46437(100, 12).method_46431());
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.copy"), __ -> this.area.copyNode()).method_46437(100, 12).method_46431());
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.paste"), __ -> this.area.pasteNode(x, y)).method_46437(100, 12).method_46431());
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.cut"), __ -> this.area.cutNode()).method_46437(100, 12).method_46431());
            if (NodeConfigScreenRegistry.hasConfig(node.node)) {
                this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.configure"), __ -> this.area.configureNode()).method_46437(100, 12).method_46431());
            }
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.tag"), __ -> this.setupTagging()).method_46437(100, 12).method_46431());
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.name"), __ -> this.setupNaming()).method_46437(100, 12).method_46431());
        } else {
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.paste"), __ -> this.area.pasteNode(x, y)).method_46437(100, 12).method_46431());
        }
        this.node = node;
        this.positionWidgets(x, y);
        this.area.method_25395((class_364)this);
    }

    private void positionWidgets(int x, int y) {
        int totalHeight = this.widgets.stream().mapToInt(class_339::method_25364).sum();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        int currentY = Math.min(y, screenHeight - totalHeight - 10);
        for (class_339 button : this.widgets) {
            button.method_46421(x);
            button.method_46419(currentY);
            currentY += button.method_25364();
        }
        if (!this.widgets.isEmpty()) {
            this.method_25395((class_364)this.widgets.get(0));
        }
    }

    public void hide() {
        this.widgets.clear();
    }

    private void setupTagging() {
        if (this.widgets.isEmpty()) {
            NodeFlow.LOGGER.warn("Tried to setup tagging without showing context menu");
            return;
        }
        int x = this.widgets.get(0).method_46426();
        int y = this.widgets.get(0).method_46427();
        this.widgets.clear();
        this.widgets.add((class_339)class_4185.method_46430((class_2561)class_5244.field_24339, __ -> this.show(x, y, this.node)).method_46437(100, 12).method_46431());
        for (NodeTag tag : NodeTag.values()) {
            class_5250 text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u25a0 ").method_10862(class_2583.field_24360.method_36139(tag.getColor()))).method_10852((class_2561)class_2561.method_43471((String)("nodeflow.editor.node_tag." + tag.asString())));
            this.widgets.add((class_339)class_4185.method_46430((class_2561)text, __ -> this.area.tagNode(tag)).method_46437(100, 12).method_46431());
        }
        this.positionWidgets(x, y);
    }

    private void setupNaming() {
        if (this.widgets.isEmpty()) {
            NodeFlow.LOGGER.warn("Tried to setup naming without showing context menu");
            return;
        }
        int x = this.widgets.get(0).method_46426();
        int y = this.widgets.get(0).method_46427();
        this.widgets.clear();
        this.widgets.add((class_339)class_4185.method_46430((class_2561)class_5244.field_24339, __ -> this.show(x, y, this.node)).method_46437(100, 12).method_46431());
        if (this.node.node.nickname != null) {
            this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.clear_name"), __ -> this.area.renameNode(null)).method_46437(100, 12).method_46431());
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        class_342 textField = new class_342(textRenderer, 100, 20, (class_2561)class_2561.method_43473());
        textField.method_47404((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.nick_placeholder").method_27692(class_124.field_1080));
        textField.method_1880(16);
        if (this.node.node.nickname != null) {
            textField.method_1852(this.node.node.nickname);
        }
        this.widgets.add((class_339)textField);
        this.widgets.add((class_339)class_4185.method_46430((class_2561)class_5244.field_24334, __ -> this.area.renameNode(textField.method_1882())).method_46437(100, 12).method_46431());
        this.positionWidgets(x, y);
    }

    public boolean isVisible() {
        return !this.method_25396().isEmpty();
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        for (class_339 button : this.widgets) {
            button.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.widgets.isEmpty()) {
            return false;
        }
        if (!super.method_25402(mouseX, mouseY, button)) {
            this.hide();
        }
        return true;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        for (class_339 widget : this.widgets) {
            if (!widget.method_25405(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        class_8016 path = super.method_48205(navigation);
        if (path == null) {
            this.hide();
        }
        return path;
    }
}

