/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.client.ui.widget;

import com.google.common.collect.Lists;
import io.github.mattidragon.nodeflow.NodeFlow;
import io.github.mattidragon.nodeflow.client.ui.NodeConfigScreenRegistry;
import io.github.mattidragon.nodeflow.client.ui.screen.EditorScreen;
import io.github.mattidragon.nodeflow.client.ui.widget.ContextMenuWidget;
import io.github.mattidragon.nodeflow.client.ui.widget.NodeWidget;
import io.github.mattidragon.nodeflow.client.ui.widget.ZoomableAreaWidget;
import io.github.mattidragon.nodeflow.graph.Connection;
import io.github.mattidragon.nodeflow.graph.node.Node;
import io.github.mattidragon.nodeflow.graph.node.NodeTag;
import io.github.mattidragon.nodeflow.graph.node.NodeType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EditorAreaWidget
extends ZoomableAreaWidget<NodeWidget> {
    private static final String CLIPBOARD_PREFIX = "nodeflow-node-v1:";
    private final EditorScreen parent;
    private final ContextMenuWidget contextMenu = new ContextMenuWidget(this);

    public EditorAreaWidget(int x, int y, int width, int height, EditorScreen parent) {
        super(x, y, width, height);
        this.parent = parent;
        this.contextMenu.hide();
    }

    void deleteNode() {
        if (this.contextMenu.node == null) {
            NodeFlow.LOGGER.warn("Clicked delete key without clicking node");
            return;
        }
        this.parent.removeNode(this.contextMenu.node);
        this.contextMenu.hide();
    }

    void duplicateNode() {
        if (this.contextMenu.node == null) {
            NodeFlow.LOGGER.warn("Clicked dupe key without clicking node");
            return;
        }
        class_2487 nbt = new class_2487();
        Node oldNode = this.contextMenu.node.node;
        oldNode.writeNbt(nbt);
        Node newNode = (Node)oldNode.type.generator().apply(this.parent.graph);
        newNode.readNbt(nbt);
        newNode.id = UUID.randomUUID();
        newNode.guiX = oldNode.guiX + 10;
        newNode.guiY = oldNode.guiY + 10;
        this.parent.graph.addNode(newNode);
        this.add(new NodeWidget(newNode, this.parent));
        this.parent.syncGraph();
        this.contextMenu.hide();
    }

    void copyNode() {
        if (this.contextMenu.node == null) {
            NodeFlow.LOGGER.warn("Clicked copy key without clicking node");
            return;
        }
        class_2487 nbt = new class_2487();
        this.contextMenu.node.node.writeNbt(nbt);
        nbt.method_10551("guiX");
        nbt.method_10551("guiY");
        nbt.method_10551("id");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (OutputStream out = Base64.getEncoder().wrap(bytes);){
            class_2507.method_10634((class_2487)nbt, (OutputStream)out);
        }
        catch (IOException e) {
            NodeFlow.LOGGER.warn("Failed to copy node", (Throwable)e);
            return;
        }
        class_310.method_1551().field_1774.method_1455(CLIPBOARD_PREFIX + String.valueOf(bytes));
        this.contextMenu.hide();
    }

    void cutNode() {
        if (this.contextMenu.node == null) {
            NodeFlow.LOGGER.warn("Clicked cut key without clicking node");
            return;
        }
        class_2487 nbt = new class_2487();
        this.contextMenu.node.node.writeNbt(nbt);
        nbt.method_10551("guiX");
        nbt.method_10551("guiY");
        nbt.method_10551("id");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (OutputStream out = Base64.getEncoder().wrap(bytes);){
            class_2507.method_10634((class_2487)nbt, (OutputStream)out);
        }
        catch (IOException e) {
            NodeFlow.LOGGER.warn("Failed to cut node", (Throwable)e);
            return;
        }
        class_310.method_1551().field_1774.method_1455(CLIPBOARD_PREFIX + String.valueOf(bytes));
        this.parent.removeNode(this.contextMenu.node);
        this.contextMenu.hide();
    }

    void pasteNode(double mouseX, double mouseY) {
        class_2487 nbt;
        String clipboard = class_310.method_1551().field_1774.method_1460();
        if (!clipboard.startsWith(CLIPBOARD_PREFIX)) {
            return;
        }
        ByteArrayInputStream bytes = new ByteArrayInputStream(clipboard.substring(CLIPBOARD_PREFIX.length()).getBytes());
        try (InputStream in = Base64.getDecoder().wrap(bytes);){
            nbt = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
        }
        catch (IOException e) {
            NodeFlow.LOGGER.warn("Failed to paste node", (Throwable)e);
            return;
        }
        Optional type = nbt.method_67491("type", NodeType.REGISTRY.method_39673());
        if (type.isEmpty()) {
            NodeFlow.LOGGER.warn("Failed to paste node, invalid type");
            return;
        }
        Node node = (Node)((NodeType)type.get()).generator().apply(this.parent.graph);
        node.readNbt(nbt);
        node.guiX = (int)this.modifyX(mouseX);
        node.guiY = (int)this.modifyY(mouseY);
        this.parent.graph.addNode(node);
        this.add(new NodeWidget(node, this.parent));
        this.parent.syncGraph();
        this.contextMenu.hide();
    }

    void configureNode() {
        if (this.contextMenu.node == null) {
            NodeFlow.LOGGER.warn("Clicked dupe key without clicking node");
            return;
        }
        class_310.method_1551().method_1507(NodeConfigScreenRegistry.createScreen(this.contextMenu.node.node, this.parent));
        this.contextMenu.hide();
    }

    void tagNode(NodeTag tag) {
        if (this.contextMenu.node == null) {
            NodeFlow.LOGGER.warn("Clicked tag key without clicking node");
            return;
        }
        this.contextMenu.node.node.tag = tag;
        this.parent.syncGraph();
        this.contextMenu.hide();
    }

    void renameNode(@Nullable String name) {
        if (this.contextMenu.node == null) {
            NodeFlow.LOGGER.warn("Trying to rename node without clicking node");
            return;
        }
        if (name != null && name.isBlank()) {
            name = null;
        }
        this.contextMenu.node.node.nickname = name;
        this.contextMenu.node.updateWidth();
        this.parent.syncGraph();
        this.contextMenu.hide();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1) {
            for (NodeWidget node : Lists.reverse(this.method_25396())) {
                if (!node.method_25405(this.modifyX(mouseX), this.modifyY(mouseY))) continue;
                this.setContextMenu((int)mouseX, (int)mouseY, node);
                return true;
            }
            this.setContextMenu((int)mouseX, (int)mouseY, null);
            return true;
        }
        return this.contextMenu.method_25402(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY) || this.contextMenu.method_25405(mouseX, mouseY);
    }

    public void setContextMenu(int x, int y, @Nullable NodeWidget node) {
        this.contextMenu.show(x, y, node);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_437.method_25437((int)keyCode)) {
            this.pasteNode((double)this.x + (double)this.width / 2.0, (double)this.x + (double)this.height / 2.0);
            return true;
        }
        if (this.contextMenu.isVisible() && (keyCode == 265 || keyCode == 264)) {
            return false;
        }
        if (this.contextMenu.isVisible() && (keyCode == 263 || keyCode == 262)) {
            this.contextMenu.hide();
            return false;
        }
        return this.contextMenu.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.contextMenu.method_25400(chr, modifiers) || super.method_25400(chr, modifiers);
    }

    @Override
    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (this.method_25399() != null) {
            this.method_25399().method_25365(focused);
        }
    }

    public EditorScreen getParent() {
        return this.parent;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.contextMenu.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    protected void renderExtras(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderConnectors(context, mouseX, mouseY);
    }

    private void renderConnectors(class_332 context, int mouseX, int mouseY) {
        if (this.parent.connectingConnector != null) {
            NodeWidget.Segment row = this.parent.findSegmentAt(mouseX, mouseY);
            int targetX = (int)this.modifyX(mouseX);
            int targetY = (int)this.modifyY(mouseY);
            if (row != null) {
                targetX = row.getConnectorX();
                targetY = row.getConnectorY();
            }
            NodeWidget.Segment connectingSegment = this.parent.findSegment(this.parent.connectingConnector);
            EditorAreaWidget.renderConnectorLine(context, targetX, targetY, connectingSegment.getConnectorX(), connectingSegment.getConnectorY(), this.parent.connectingConnector.type().color());
        }
        for (Connection connection : this.parent.graph.getConnections()) {
            NodeWidget.Segment input = this.parent.findSegment(Objects.requireNonNull(connection.getTargetConnector(this.parent.graph)));
            NodeWidget.Segment output = this.parent.findSegment(Objects.requireNonNull(connection.getSourceConnector(this.parent.graph)));
            EditorAreaWidget.renderConnectorLine(context, input.getConnectorX(), input.getConnectorY(), output.getConnectorX(), output.getConnectorY(), input.connector.type().color());
        }
    }

    private static void renderConnectorLine(class_332 context, int x1, int y1, int x2, int y2, int color) {
        int xOffset = (x1 - x2) / 2;
        int yOffset = y1 - y2;
        int pixelFix = (x1 - x2) % 2;
        class_2960 cornersTexture = NodeFlow.id("textures/gui/connection_corners.png");
        class_2960 horizontalTexture = NodeFlow.id("textures/gui/connection_horizontal.png");
        class_2960 verticalTexture = NodeFlow.id("textures/gui/connection_vertical.png");
        color |= 0xFF000000;
        if (xOffset == 0) {
            int vOffset = yOffset < 0 ? -2 : 2;
            context.method_25291(class_10799.field_56883, cornersTexture, x2, y2, 8.0f, (float)(10 + vOffset), 4, 4, 12, 20, color);
            context.method_25291(class_10799.field_56883, cornersTexture, x1, y1, 8.0f, (float)(10 - vOffset), 4, 4, 12, 20, color);
        } else if (xOffset > 0) {
            context.method_25291(class_10799.field_56883, cornersTexture, x2, y2, 8.0f, 0.0f, 4, 4, 12, 20, color);
            context.method_25291(class_10799.field_56883, cornersTexture, x1, y1, 8.0f, 4.0f, 4, 4, 12, 20, color);
        } else {
            context.method_25291(class_10799.field_56883, cornersTexture, x2, y2, 8.0f, 4.0f, 4, 4, 12, 20, color);
            context.method_25291(class_10799.field_56883, cornersTexture, x1, y1, 8.0f, 0.0f, 4, 4, 12, 20, color);
        }
        if (xOffset > 0) {
            context.method_25291(class_10799.field_56883, horizontalTexture, x2 + 4, y2, 0.0f, 0.0f, xOffset - 4 + pixelFix, 4, 4, 4, color);
            context.method_25291(class_10799.field_56883, horizontalTexture, x1 - xOffset + 4, y1, 0.0f, 0.0f, xOffset - 4, 4, 4, 4, color);
        } else if (xOffset != 0) {
            context.method_25291(class_10799.field_56883, horizontalTexture, x2 + xOffset + 4 + pixelFix, y2, 0.0f, 0.0f, -xOffset - 4 - pixelFix, 4, 4, 4, color);
            context.method_25291(class_10799.field_56883, horizontalTexture, x1 + 4, y1, 0.0f, 0.0f, -xOffset - 4, 4, 4, 4, color);
        }
        if (yOffset == 0) {
            context.method_25291(class_10799.field_56883, horizontalTexture, x1 - xOffset, y1, 0.0f, 0.0f, 4, 4, 4, 4, color);
        } else if (yOffset > 0) {
            context.method_25291(class_10799.field_56883, verticalTexture, x1 - xOffset, y1 - yOffset + 4, 0.0f, 0.0f, 4, yOffset - 4, 4, 4, color);
        } else {
            context.method_25291(class_10799.field_56883, verticalTexture, x1 - xOffset, y1 + 4, 0.0f, 0.0f, 4, -yOffset - 4, 4, 4, color);
        }
        if (xOffset != 0 && yOffset != 0) {
            if (yOffset < 0) {
                int n = cornerU = xOffset < 0 ? 4 : 0;
                if (yOffset == -1) {
                    context.method_25291(class_10799.field_56883, cornersTexture, x1 - xOffset, y1, (float)cornerU, 14.0f, 4, 5, 12, 20, color);
                } else if (yOffset == -2) {
                    context.method_25291(class_10799.field_56883, cornersTexture, x1 - xOffset, y1, (float)cornerU, 8.0f, 4, 6, 12, 20, color);
                } else {
                    context.method_25291(class_10799.field_56883, cornersTexture, x1 - xOffset, y1 - yOffset, (float)cornerU, 4.0f, 4, 4, 12, 20, color);
                    context.method_25291(class_10799.field_56883, cornersTexture, x1 - xOffset, y1, (float)cornerU, 0.0f, 4, 4, 12, 20, color);
                }
            } else {
                int n = cornerU = xOffset < 0 ? 0 : 4;
                if (yOffset == 1) {
                    context.method_25291(class_10799.field_56883, cornersTexture, x1 - xOffset, y1 - yOffset, (float)cornerU, 14.0f, 4, 5, 12, 20, color);
                } else if (yOffset == 2) {
                    context.method_25291(class_10799.field_56883, cornersTexture, x1 - xOffset, y1 - yOffset, (float)cornerU, 8.0f, 4, 6, 12, 20, color);
                } else {
                    context.method_25291(class_10799.field_56883, cornersTexture, x1 - xOffset, y1 - yOffset, (float)cornerU, 0.0f, 4, 4, 12, 20, color);
                    context.method_25291(class_10799.field_56883, cornersTexture, x1 - xOffset, y1, (float)cornerU, 4.0f, 4, 4, 12, 20, color);
                }
            }
        }
    }
}

