/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.client.ui.widget;

import io.github.mattidragon.nodeflow.NodeFlow;
import io.github.mattidragon.nodeflow.client.ui.NodeConfigScreenRegistry;
import io.github.mattidragon.nodeflow.client.ui.screen.EditorScreen;
import io.github.mattidragon.nodeflow.client.ui.widget.EditorAreaWidget;
import io.github.mattidragon.nodeflow.graph.Connector;
import io.github.mattidragon.nodeflow.graph.node.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import net.minecraft.class_8494;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class NodeWidget
extends class_339 {
    public static final int ROW_HEIGHT = 12;
    public final Node node;
    private final EditorScreen parent;
    private int dragX;
    private int dragY;

    public NodeWidget(Node node, EditorScreen parent) {
        super(node.guiX, node.guiY, NodeWidget.calcWidth(node, Screens.getTextRenderer((class_437)parent)), 32 + (node.getInputs().length + node.getOutputs().length) * 12, node.getName());
        this.method_46421(this.method_46426() - this.field_22758 / 2);
        this.method_46419(this.method_46427() - this.field_22759 / 2);
        this.node = node;
        this.parent = parent;
        this.updateTooltip();
    }

    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    private static int calcWidth(Node node, class_327 renderer) {
        int fieldMax = Stream.concat(Arrays.stream(node.getInputs()), Arrays.stream(node.getOutputs())).map(Connector::id).mapToInt(arg_0 -> ((class_327)renderer).method_1727(arg_0)).map(width -> width + 24).max().orElse(0);
        return Math.max(fieldMax, renderer.method_27525((class_5348)node.getName()) + 32);
    }

    public Segment[] calculateSegments() {
        Segment[] segments = new Segment[this.node.getInputs().length + this.node.getOutputs().length];
        int i = 0;
        for (Connector<?> input : this.node.getInputs()) {
            segments[i++] = new Segment(this.method_46426(), this.method_46427() + 12 + i * 12, false, input);
        }
        for (Connector<?> output : this.node.getOutputs()) {
            segments[i++] = new Segment(this.method_46426(), this.method_46427() + 12 + i * 12, true, output);
        }
        return segments;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        if (class_8494.method_51255((int)keyCode)) {
            this.method_25354(class_310.method_1551().method_1483());
            EditorAreaWidget area = this.parent.getArea();
            area.setContextMenu((int)area.reverseModifyX(this.method_46426()), (int)area.reverseModifyY(this.method_46427()), this);
            return true;
        }
        switch (keyCode) {
            case 263: {
                this.method_46421(this.method_46426() - 10);
                this.updateNodePos();
                return true;
            }
            case 264: {
                this.method_46419(this.method_46427() + 10);
                this.updateNodePos();
                return true;
            }
            case 265: {
                this.method_46419(this.method_46427() - 10);
                this.updateNodePos();
                return true;
            }
            case 262: {
                this.method_46421(this.method_46426() + 10);
                this.updateNodePos();
                return true;
            }
        }
        return false;
    }

    public void method_25348(double mouseX, double mouseY) {
        if (this.parent.isDeletingNode()) {
            this.parent.removeNode(this);
            return;
        }
        this.dragX = (int)((double)this.method_46426() - mouseX);
        this.dragY = (int)((double)this.method_46427() - mouseY);
        if (NodeConfigScreenRegistry.hasConfig(this.node) && this.isMouseOnButton(mouseX, mouseY)) {
            class_310.method_1551().method_1507(NodeConfigScreenRegistry.createScreen(this.node, this.parent));
            return;
        }
        for (Segment row : this.calculateSegments()) {
            if (!row.hasConnectorAt(mouseX, mouseY)) continue;
            this.parent.connectingConnector = row.connector;
            break;
        }
    }

    private boolean isMouseOnButton(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() + this.field_22758 - 20) && mouseX <= (double)(this.method_46426() + this.field_22758 - 4) && mouseY >= (double)(this.method_46427() + 4) && mouseY <= (double)(this.method_46427() + 20);
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.parent.connectingConnector != null) {
            return;
        }
        this.method_46421((int)(mouseX + (double)this.dragX));
        this.method_46419((int)(mouseY + (double)this.dragY));
        this.updateNodePos();
    }

    private void updateNodePos() {
        this.node.guiX = this.method_46426() + this.field_22758 / 2;
        this.node.guiY = this.method_46427() + this.field_22759 / 2;
    }

    public void updateTooltip() {
        boolean hasError;
        ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
        boolean bl = hasError = !this.node.validate().isEmpty() || !this.node.isFullyConnected();
        if (NodeConfigScreenRegistry.hasConfig(this.node)) {
            tooltip.add(class_2561.method_43471((String)"nodeflow.editor.button.config.tooltip").method_27692(class_124.field_1068));
        }
        if (hasError) {
            tooltip.add(class_2561.method_43471((String)"nodeflow.editor.button.config.tooltip.errors").method_27692(class_124.field_1061));
        }
        if (!this.node.validate().isEmpty()) {
            tooltip.add(class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.config.tooltip.invalid_config").method_27692(class_124.field_1061)));
        }
        if (!this.node.isFullyConnected()) {
            tooltip.add(class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"nodeflow.editor.button.config.tooltip.not_connected").method_27692(class_124.field_1061)));
        }
        this.method_47400(class_7919.method_47407((class_2561)class_2564.method_37112(tooltip, (class_2561)class_2561.method_43470((String)"\n"))));
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 textRenderer = Screens.getTextRenderer((class_437)this.parent);
        class_2960 texture = this.method_25370() ? NodeFlow.id("node_selected") : NodeFlow.id("node");
        int tagColor = this.node.tag.getColor();
        context.method_52707(class_10799.field_56883, texture, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, tagColor | 0xFF000000);
        int color = -1;
        if (!this.node.isFullyConnected()) {
            color = -21931;
        }
        if (!this.node.validate().isEmpty()) {
            color = -21931;
        }
        if (NodeConfigScreenRegistry.hasConfig(this.node) && this.method_25405(mouseX, mouseY)) {
            color = -6710785;
        }
        if (!this.node.isFullyConnected() || !this.node.validate().isEmpty()) {
            context.method_52707(class_10799.field_56883, NodeFlow.id("config_button_error"), this.method_46426() + this.field_22758 - 20, this.method_46427() + 4, 16, 16, color);
        } else if (NodeConfigScreenRegistry.hasConfig(this.node)) {
            context.method_52707(class_10799.field_56883, NodeFlow.id("config_button"), this.method_46426() + this.field_22758 - 20, this.method_46427() + 4, 16, 16, color);
        }
        for (Segment segment : this.calculateSegments()) {
            segment.render(context, mouseX, mouseY);
        }
        context.method_51439(textRenderer, this.method_25369(), this.method_46426() + 7, this.method_46427() + 7, -12566464, false);
        if (!this.isMouseOnButton(mouseX, mouseY)) {
            this.field_22762 = false;
        }
    }

    public class_2561 method_25369() {
        return this.node.getName();
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        EditorAreaWidget area = this.parent.getArea();
        if (area.reverseModifyX(this.method_46426() + this.field_22758) < (double)area.x || area.reverseModifyY(this.method_46427() + this.field_22759) < (double)area.y || area.reverseModifyX(this.method_46426()) > (double)(area.x + area.width) || area.reverseModifyY(this.method_46427()) > (double)(area.y + area.height)) {
            return null;
        }
        return super.method_48205(navigation);
    }

    public EditorScreen getParent() {
        return this.parent;
    }

    public class_8030 method_48202() {
        EditorAreaWidget area = this.parent.getArea();
        return new class_8030((int)area.reverseModifyX(this.method_46426()), (int)area.reverseModifyY(this.method_46427()), (int)area.reverseModifyDeltaX(this.method_25368()), (int)area.reverseModifyDeltaY(this.method_25364()));
    }

    public void updateWidth() {
        this.field_22758 = NodeWidget.calcWidth(this.node, Screens.getTextRenderer((class_437)this.parent));
    }

    @Environment(value=EnvType.CLIENT)
    public class Segment {
        public final int x;
        public final int y;
        public final Connector<?> connector;
        public final boolean isOutput;

        public Segment(int x, int y, boolean isOutput, Connector<?> connector) {
            this.x = x;
            this.y = y;
            this.isOutput = isOutput;
            this.connector = connector;
        }

        public int getConnectorX() {
            return this.isOutput ? this.x + NodeWidget.this.field_22758 - 12 : this.x + 8;
        }

        public int getConnectorY() {
            return this.y + 4;
        }

        public boolean hasConnectorAt(double mouseX, double mouseY) {
            return mouseX > (double)(this.getConnectorX() - 2) && mouseX < (double)(this.getConnectorX() + 6) && mouseY > (double)(this.getConnectorY() - 2) && mouseY < (double)(this.getConnectorY() + 6);
        }

        public void render(class_332 context, int mouseX, int mouseY) {
            class_327 textRenderer = Screens.getTextRenderer((class_437)NodeWidget.this.parent);
            int brightness = this.hasConnectorAt(mouseX, mouseY) ? 2 : 1;
            int color = this.connector.type().color();
            color = 0xFF000000 | Math.min((color >> 16 & 0xFF) * brightness, 255) << 16 | Math.min((color >> 8 & 0xFF) * brightness, 255) << 8 | Math.min((color & 0xFF) * brightness, 255);
            context.method_52707(class_10799.field_56883, NodeFlow.id("connector"), this.getConnectorX(), this.getConnectorY(), 4, 4, color);
            if (!this.isOutput) {
                context.method_51433(textRenderer, this.connector.id(), this.x + 16, this.y + 2, -12566464, false);
            } else {
                context.method_51433(textRenderer, this.connector.id(), this.x + NodeWidget.this.field_22758 - 16 - textRenderer.method_1727(this.connector.id()), this.y + 2, -12566464, false);
            }
        }
    }
}

