/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.client.ui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class ZoomableAreaWidget<T extends class_364 & class_4068>
extends class_362
implements class_4068,
class_6379 {
    private final List<T> children = new ArrayList<T>();
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public boolean visible = true;
    public boolean active = true;
    private boolean focused = false;
    private int zoom;
    private double viewX;
    private double viewY;
    private float scale = Float.NaN;

    public ZoomableAreaWidget(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public List<T> method_25396() {
        return this.children;
    }

    public void remove(T child) {
        this.children.remove(child);
    }

    public void add(T child) {
        this.children.add(child);
    }

    public int getZoom() {
        return this.zoom;
    }

    public float getScale() {
        if (Float.isNaN(this.scale)) {
            this.scale = (float)Math.pow(2.0, (double)this.zoom / 2.0);
        }
        return this.scale;
    }

    public void zoom(int amount, double x, double y) {
        double anchorX = this.modifyX(x);
        double anchorY = this.modifyY(y);
        this.zoom += amount;
        this.zoom = class_3532.method_15340((int)this.zoom, (int)-5, (int)5);
        this.scale = Float.NaN;
        this.viewX = -(anchorX * (double)this.getScale() - x + (double)this.x + (double)this.width / 2.0);
        this.viewY = -(anchorY * (double)this.getScale() - y + (double)this.y + (double)this.height / 2.0);
    }

    public double modifyX(double originalX) {
        return this.modifyDeltaX(originalX - (double)this.x - this.viewX - (double)this.width / 2.0);
    }

    public double modifyY(double originalY) {
        return this.modifyDeltaY(originalY - (double)this.y - this.viewY - (double)this.height / 2.0);
    }

    public double modifyDeltaX(double originalX) {
        return originalX / (double)this.getScale();
    }

    public double modifyDeltaY(double originalY) {
        return originalY / (double)this.getScale();
    }

    public double reverseModifyX(double originalX) {
        return this.reverseModifyDeltaX(originalX) + (double)this.x + this.viewX + (double)this.width / 2.0;
    }

    public double reverseModifyY(double originalY) {
        return this.reverseModifyDeltaY(originalY) + (double)this.y + this.viewY + (double)this.height / 2.0;
    }

    public double reverseModifyDeltaX(double originalX) {
        return originalX * (double)this.getScale();
    }

    public double reverseModifyDeltaY(double originalY) {
        return originalY * (double)this.getScale();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!(this.method_25405(mouseX, mouseY) && this.active && this.visible)) {
            return false;
        }
        if (super.method_25402(this.modifyX(mouseX), this.modifyY(mouseY), button)) {
            class_364 focused = this.method_25399();
            if (this.children.remove(focused)) {
                this.children.addFirst(focused);
            }
        } else {
            this.method_25395(null);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!(this.method_25405(mouseX, mouseY) && this.active && this.visible)) {
            return false;
        }
        return super.method_25406(this.modifyX(mouseX), this.modifyY(mouseY), button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!(this.method_25405(mouseX, mouseY) && this.active && this.visible)) {
            return false;
        }
        if (super.method_25403(this.modifyX(mouseX), this.modifyY(mouseY), button, this.modifyDeltaX(deltaX), this.modifyDeltaY(deltaY))) {
            return true;
        }
        this.viewX += deltaX;
        this.viewY += deltaY;
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (!(this.method_25405(mouseX, mouseY) && this.active && this.visible)) {
            return;
        }
        super.method_16014(this.modifyX(mouseX), this.modifyY(mouseY));
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!(this.method_25405(mouseX, mouseY) && this.active && this.visible)) {
            return false;
        }
        if (super.method_25401(this.modifyX(mouseX), this.modifyY(mouseY), horizontalAmount, verticalAmount)) {
            return true;
        }
        this.zoom((int)verticalAmount, mouseX, mouseY);
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.active || !this.visible) {
            return false;
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 265: {
                this.viewY += 10.0;
                break;
            }
            case 264: {
                this.viewY -= 10.0;
                break;
            }
            case 262: {
                this.viewX -= 10.0;
                break;
            }
            case 263: {
                this.viewX += 10.0;
                break;
            }
            case 45: 
            case 333: {
                this.zoom(-1, (double)this.x + (double)this.width / 2.0, (double)this.y + (double)this.height / 2.0);
                break;
            }
            case 334: {
                this.zoom(1, (double)this.x + (double)this.width / 2.0, (double)this.y + (double)this.height / 2.0);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        Matrix3x2fStack matrices = context.method_51448();
        context.method_44379(this.x, this.y, this.x + this.width, this.y + this.height);
        matrices.pushMatrix();
        matrices.translate((float)this.x, (float)this.y);
        matrices.translate((float)(this.viewX + (double)this.width / 2.0), (float)(this.viewY + (double)this.height / 2.0));
        float scale = this.getScale();
        matrices.scale(scale, scale);
        for (class_364 child : Lists.reverse(this.children)) {
            ((class_4068)child).method_25394(context, (int)Math.floor(this.modifyX(mouseX)), (int)Math.floor(this.modifyY(mouseY)), delta);
        }
        this.renderExtras(context, mouseX, mouseY, delta);
        matrices.popMatrix();
        context.method_44380();
    }

    protected void renderExtras(class_332 matrices, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.active && this.visible && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    public class_8030 method_48202() {
        return new class_8030(this.x, this.y, this.width, this.height);
    }

    public void method_37020(class_6382 builder) {
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof class_6383) {
            class_6383 narratable = (class_6383)class_3642;
            narratable.method_37020(builder);
        }
    }

    public boolean method_37303() {
        return this.active && this.visible;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33786;
    }

    public double getViewX() {
        return this.viewX;
    }

    public double getViewY() {
        return this.viewY;
    }

    public void setViewX(double viewX) {
        this.viewX = viewX;
    }

    public void setViewY(double viewY) {
        this.viewY = viewY;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    @Nullable
    public class_8016 method_48218() {
        return this.method_25399() == null ? class_8016.method_48193((class_364)this) : super.method_48218();
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        if (!this.active) {
            return null;
        }
        if (!this.method_25370()) {
            return class_8016.method_48193((class_364)this);
        }
        if (this.method_25399() == null && navigation.equals((Object)new class_8023.class_8026(false))) {
            return null;
        }
        return super.method_48205(navigation);
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
        if (!focused) {
            this.method_25395(null);
        }
    }

    public boolean method_25370() {
        return this.focused;
    }
}

