/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.graph;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mattidragon.nodeflow.graph.Connector;
import io.github.mattidragon.nodeflow.graph.Graph;
import java.util.UUID;
import net.minecraft.class_4844;

public record Connection(UUID targetUuid, String targetName, UUID sourceUuid, String sourceName) {
    public static final Codec<Connection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_40825.fieldOf("inputUuid").forGetter(Connection::targetUuid), (App)Codec.STRING.fieldOf("inputName").forGetter(Connection::targetName), (App)class_4844.field_40825.fieldOf("outputUuid").forGetter(Connection::sourceUuid), (App)Codec.STRING.fieldOf("outputName").forGetter(Connection::sourceName)).apply((Applicative)instance, Connection::new));

    public Connector<?> getTargetConnector(Graph graph) {
        for (Connector<?> input : graph.getNode(this.targetUuid).getInputs()) {
            if (!input.id().equals(this.targetName)) continue;
            return input;
        }
        return null;
    }

    public Connector<?> getSourceConnector(Graph graph) {
        for (Connector<?> output : graph.getNode(this.sourceUuid).getOutputs()) {
            if (!output.id().equals(this.sourceName)) continue;
            return output;
        }
        return null;
    }
}

