/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.graph;

import com.mojang.datafixers.util.Either;
import io.github.mattidragon.nodeflow.NodeFlow;
import io.github.mattidragon.nodeflow.graph.Connection;
import io.github.mattidragon.nodeflow.graph.Connector;
import io.github.mattidragon.nodeflow.graph.GraphEnvironment;
import io.github.mattidragon.nodeflow.graph.context.Context;
import io.github.mattidragon.nodeflow.graph.context.ContextType;
import io.github.mattidragon.nodeflow.graph.data.DataValue;
import io.github.mattidragon.nodeflow.graph.node.Node;
import io.github.mattidragon.nodeflow.graph.node.NodeType;
import io.github.mattidragon.nodeflow.misc.EvaluationError;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class Graph {
    public static final class_9139<class_9129, Graph> PACKET_CODEC = class_9139.method_56437((buf, graph) -> {
        GraphEnvironment.PACKET_CODEC.encode(buf, (Object)graph.env);
        class_2487 nbt = new class_2487();
        graph.writeNbt(nbt);
        buf.method_10794((class_2520)nbt);
    }, buf -> {
        GraphEnvironment environment = (GraphEnvironment)GraphEnvironment.PACKET_CODEC.decode(buf);
        Graph graph = new Graph(environment);
        graph.readNbt(Objects.requireNonNull(buf.method_10798(), "Missing nbt in packet"));
        return graph;
    });
    private final Map<UUID, Node> nodes = new LinkedHashMap<UUID, Node>();
    private final Set<Connection> connections = new LinkedHashSet<Connection>();
    public final GraphEnvironment env;

    public Graph(GraphEnvironment env) {
        this.env = env;
    }

    public Graph copy() {
        class_2487 nbt = new class_2487();
        this.writeNbt(nbt);
        Graph graph = new Graph(this.env);
        graph.readNbt(nbt);
        return graph;
    }

    public void addNode(Node node) {
        if (!this.env.isAllowedNodeType(node.type)) {
            throw new IllegalArgumentException("This graph doesn't support that node type: %s".formatted(node.type));
        }
        if (this.nodes.containsKey(node.id)) {
            NodeFlow.LOGGER.warn("Tried to add node that already is in graph. (id: {}, type: {})", (Object)node.id, node.type);
            return;
        }
        this.nodes.put(node.id, node);
    }

    public Node getNode(UUID id) {
        return this.nodes.get(id);
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public void removeNode(UUID id) {
        this.nodes.remove(id);
        this.connections.removeAll(this.getConnections(id));
    }

    public void removeConnections(Connector<?> connector) {
        this.connections.removeAll(this.getConnections(connector));
    }

    public void addConnection(Connector<?> target, Connector<?> source) {
        if (target.isOutput() == source.isOutput()) {
            throw new IllegalArgumentException("Adding connection target graph.");
        }
        if (target.isOutput()) {
            Connector<?> tmp = target;
            target = source;
            source = tmp;
        }
        this.connections.add(new Connection(target.parent().id, target.id(), source.parent().id, source.id()));
    }

    public void cleanConnections(Node node) {
        this.getConnections(node.id).stream().filter(connection -> {
            Connector<?> input = connection.getTargetConnector(this);
            Connector<?> output = connection.getSourceConnector(this);
            return input == null || output == null || input.type() != output.type();
        }).forEach(this.connections::remove);
    }

    public Set<Connection> getConnections() {
        return Collections.unmodifiableSet(this.connections);
    }

    public Set<Connection> getConnections(UUID node) {
        return this.connections.stream().filter(connection -> connection.targetUuid().equals(node) || connection.sourceUuid().equals(node)).collect(Collectors.toCollection(HashSet::new));
    }

    public Set<Connection> getConnections(Connector<?> connector) {
        if (connector.isOutput()) {
            return this.connections.stream().filter(connection -> connector.equals(connection.getSourceConnector(this))).collect(Collectors.toCollection(HashSet::new));
        }
        for (Connection connection2 : this.connections) {
            if (!connector.equals(connection2.getTargetConnector(this))) continue;
            return Set.of(connection2);
        }
        return Set.of();
    }

    public void writeNbt(class_2487 data) {
        data.method_10566("nodes", (class_2520)this.nodes.values().stream().map(node -> {
            class_2487 nbt = new class_2487();
            node.writeNbt(nbt);
            return nbt;
        }).collect(Collectors.toCollection(class_2499::new)));
        data.method_67494("connections", Connection.CODEC.listOf(), List.copyOf(this.connections));
    }

    public void readNbt(class_2487 data) {
        ArrayList<UUID> ignoredIds = new ArrayList<UUID>();
        this.nodes.clear();
        for (class_2520 element : data.method_10554("nodes").orElseGet(class_2499::new)) {
            if (!(element instanceof class_2487)) continue;
            class_2487 nodeNbt = (class_2487)element;
            Optional type = nodeNbt.method_10558("type").flatMap(s -> Optional.ofNullable(class_2960.method_12829((String)s))).flatMap(arg_0 -> NodeType.REGISTRY.method_17966(arg_0));
            if (type.isEmpty()) {
                NodeFlow.LOGGER.warn("Unknown node type: {}. Ignoring node", (Object)nodeNbt.method_10558("type"));
                nodeNbt.method_67491("id", class_4844.field_40825).ifPresent(ignoredIds::add);
                continue;
            }
            if (!this.env.isAllowedNodeType((NodeType)type.get())) {
                NodeFlow.LOGGER.warn("Unsupported node type: {}. Ignoring node", (Object)nodeNbt.method_10558("type"));
                nodeNbt.method_67491("id", class_4844.field_40825).ifPresent(ignoredIds::add);
                continue;
            }
            Node node = (Node)((NodeType)type.get()).generator().apply(this);
            node.readNbt(nodeNbt);
            this.nodes.put(node.id, node);
        }
        this.connections.clear();
        for (Connection connection : data.method_67491("connections", Connection.CODEC.listOf()).orElse(List.of())) {
            if (!this.validateConnection(connection, ignoredIds)) continue;
            this.connections.add(connection);
        }
    }

    private boolean validateConnection(Connection connection, ArrayList<UUID> ignoredIds) {
        if (ignoredIds.contains(connection.targetUuid()) || ignoredIds.contains(connection.sourceUuid())) {
            return false;
        }
        if (!this.nodes.containsKey(connection.targetUuid())) {
            NodeFlow.LOGGER.warn("Found connections to non-existent node. Id: {}.", (Object)connection.targetUuid());
            ignoredIds.add(connection.targetUuid());
            return false;
        }
        if (!this.nodes.containsKey(connection.sourceUuid())) {
            NodeFlow.LOGGER.warn("Found connections to non-existent node. Id: {}.", (Object)connection.sourceUuid());
            ignoredIds.add(connection.sourceUuid());
            return false;
        }
        if (Arrays.stream(this.nodes.get(connection.targetUuid()).getInputs()).noneMatch(input -> input.id().equals(connection.targetName()))) {
            NodeFlow.LOGGER.warn("Found connection to non-existent input. Name: {}, Node: {}.", (Object)connection.targetName(), (Object)connection.targetUuid());
            return false;
        }
        if (Arrays.stream(this.nodes.get(connection.sourceUuid()).getOutputs()).noneMatch(output -> output.id().equals(connection.sourceName()))) {
            NodeFlow.LOGGER.warn("Found connection to non-existent output. Name: {}, Node: {}.", (Object)connection.sourceName(), (Object)connection.sourceUuid());
            return false;
        }
        return true;
    }

    public List<EvaluationError> evaluate(Context context) {
        if (this.nodes.values().stream().anyMatch(Predicate.not(Node::isFullyConnected))) {
            return List.of(EvaluationError.Type.NOT_CONNECTED.error(new Object[0]));
        }
        for (Node node2 : this.nodes.values()) {
            List<class_2561> errors = node2.validate();
            if (errors.isEmpty()) continue;
            return List.of(EvaluationError.Type.INVALID_CONFIG.error(errors.getFirst().method_27661().method_27692(class_124.field_1054)));
        }
        int nodesProcessed = 0;
        Object2IntOpenHashMap inputCounts = new Object2IntOpenHashMap(this.nodes.size());
        inputCounts.defaultReturnValue(0);
        HashMap<Node, Map> availableInputs = new HashMap<Node, Map>();
        for (Connection connection : this.connections) {
            inputCounts.addTo((Object)this.nodes.get(connection.targetUuid()), 1);
        }
        List<Node> readyNodes = this.nodes.values().stream().filter(node -> inputCounts.getInt(node) == 0).toList();
        while (!readyNodes.isEmpty()) {
            ArrayList<Node> nextNodes = new ArrayList<Node>();
            for (Node node3 : readyNodes) {
                Either<DataValue<?>[], class_2561> either;
                Map inputValues = availableInputs.computeIfAbsent(node3, __ -> new HashMap());
                Connector<?>[] inputConnectors = node3.getInputs();
                List<ContextType> missingContexts = node3.contexts.stream().filter(Predicate.not(context::contains)).toList();
                if (!missingContexts.isEmpty()) {
                    return List.of(EvaluationError.Type.MISSING_CONTEXTS.error(missingContexts));
                }
                DataValue[] values = (DataValue[])Arrays.stream(inputConnectors).map(connector -> (DataValue)inputValues.get(connector.id())).toArray(DataValue[]::new);
                for (int i = 0; i < values.length; ++i) {
                    if (inputConnectors[i].type() == values[i].type()) continue;
                    return List.of(EvaluationError.Type.MISMATCHED_CONNECTION_TYPES.error(new Object[0]));
                }
                try {
                    either = node3.process(values, context);
                }
                catch (RuntimeException e) {
                    NodeFlow.LOGGER.warn("Unexpected error while evaluating node", (Throwable)e);
                    return List.of(EvaluationError.Type.EVALUATION_ERROR.error(e.getMessage()));
                }
                if (either.left().isEmpty()) {
                    return List.of(EvaluationError.Type.EVALUATION_ERROR.error(either.right().get()));
                }
                DataValue[] results = (DataValue[])either.left().get();
                Connector<?>[] expectedOutputs = node3.getOutputs();
                if (expectedOutputs.length != results.length) {
                    return List.of(EvaluationError.Type.UNEXPECTED_OUTPUT_COUNT.error(expectedOutputs.length, results.length));
                }
                for (int i = 0; i < expectedOutputs.length; ++i) {
                    Connector<?> connector2 = expectedOutputs[i];
                    DataValue value = results[i];
                    if (value.type() != connector2.type()) {
                        return List.of(EvaluationError.Type.UNEXPECTED_OUTPUT_TYPE.error(i, value.type(), connector2.type()));
                    }
                    Set<Connection> connections = this.getConnections(connector2);
                    for (Connection connection : connections) {
                        Node target = this.getNode(connection.targetUuid());
                        Map map = availableInputs.computeIfAbsent(target, __ -> new HashMap());
                        map.put(connection.targetName(), value);
                        if (map.size() != inputCounts.getInt((Object)target)) continue;
                        nextNodes.add(target);
                    }
                }
                ++nodesProcessed;
            }
            readyNodes = nextNodes;
        }
        if (nodesProcessed != this.nodes.size()) {
            return List.of(EvaluationError.Type.UNRESOLVABLE_NODES.error(nodesProcessed, this.nodes.size()));
        }
        return List.of();
    }
}

